/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import io.swagger.v3.oas.models.SpecVersion;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.CollectionUtils;

public class PropertyResolverUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyResolverUtils.class);
    private final ConfigurableBeanFactory factory;
    private final MessageSource messageSource;
    private final SpringDocConfigProperties springDocConfigProperties;

    public PropertyResolverUtils(ConfigurableBeanFactory factory, MessageSource messageSource, SpringDocConfigProperties springDocConfigProperties) {
        this.factory = factory;
        this.messageSource = messageSource;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    public String resolve(String parameterProperty, Locale locale) {
        String result = parameterProperty;
        if (parameterProperty != null) {
            if (!this.springDocConfigProperties.isDisableI18n()) {
                try {
                    result = this.messageSource.getMessage(parameterProperty, null, locale);
                }
                catch (NoSuchMessageException ex) {
                    LOGGER.trace(ex.getMessage());
                }
            }
            if (parameterProperty.equals(result)) {
                try {
                    result = this.factory.resolveEmbeddedValue(parameterProperty);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn(ex.getMessage());
                }
            }
        }
        return result;
    }

    public ConfigurableBeanFactory getFactory() {
        return this.factory;
    }

    public SpringDocConfigProperties getSpringDocConfigProperties() {
        return this.springDocConfigProperties;
    }

    public SpecVersion getSpecVersion() {
        return this.springDocConfigProperties.getSpecVersion();
    }

    public boolean isOpenapi31() {
        return this.springDocConfigProperties.isOpenapi31();
    }

    public boolean isResolveExtensionsProperties() {
        return this.springDocConfigProperties.getApiDocs().isResolveExtensionsProperties();
    }

    public Map<String, Object> resolveExtensions(Locale locale, Map<String, Object> extensions) {
        if (!CollectionUtils.isEmpty(extensions)) {
            HashMap<String, Object> extensionsResolved = new HashMap<String, Object>();
            extensions.forEach((key, value) -> {
                String keyResolved = this.resolve((String)key, locale);
                if (value instanceof HashMap) {
                    HashMap valueResolved = new HashMap();
                    ((HashMap)value).forEach((key1, value1) -> {
                        String key1Resolved = this.resolve(key1.toString(), locale);
                        String value1Resolved = this.resolve(value1.toString(), locale);
                        valueResolved.put(key1Resolved, value1Resolved);
                    });
                    extensionsResolved.put(keyResolved, valueResolved);
                } else {
                    extensionsResolved.put(keyResolved, value);
                }
            });
            return extensionsResolved;
        }
        return extensions;
    }
}

