/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Controller
public class SwaggerWelcomeWebFlux
extends SwaggerWelcomeCommon {
    private final SpringWebProvider springWebProvider;

    public SwaggerWelcomeWebFlux(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SpringWebProvider springWebProvider) {
        super(swaggerUiConfig, springDocConfigProperties);
        this.springWebProvider = springWebProvider;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        return super.redirectToUi(request, response);
    }

    protected void calculateUiRootPath(SwaggerUiConfigParameters swaggerUiConfigParameters, StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        this.calculateUiRootCommon(swaggerUiConfigParameters, sbUrl, sbUrls);
    }

    protected void calculateOauth2RedirectUrl(SwaggerUiConfigParameters swaggerUiConfigParameters, UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl()) || !swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            UriComponentsBuilder oauthPrefix = uriComponentsBuilder.path(swaggerUiConfigParameters.getContextPath()).path(swaggerUiConfigParameters.getUiRootPath()).path(this.webJarsPrefixUrl);
            swaggerUiConfigParameters.setOauth2RedirectUrl(oauthPrefix.path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    protected void buildApiDocUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setApiDocsUrl(this.buildUrlWithContextPath(swaggerUiConfigParameters, this.springDocConfigProperties.getApiDocs().getPath()));
    }

    protected String buildUrlWithContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, String swaggerUiUrl) {
        if (swaggerUiConfigParameters.getPathPrefix() == null) {
            swaggerUiConfigParameters.setPathPrefix(this.springWebProvider.findPathPrefix(this.springDocConfigProperties));
        }
        return this.buildUrl(swaggerUiConfigParameters.getContextPath() + swaggerUiConfigParameters.getPathPrefix(), swaggerUiUrl);
    }

    protected void buildSwaggerConfigUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setConfigUrl(swaggerUiConfigParameters.getApiDocsUrl() + "/swagger-config");
    }
}

