/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.webflux.ui.SwaggerIndexTransformer;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.ResourceTransformer;

public class SwaggerWebFluxConfigurer
implements WebFluxConfigurer {
    private String swaggerPath;
    private String webJarsPrefixUrl;
    private SwaggerIndexTransformer swaggerIndexTransformer;

    public SwaggerWebFluxConfigurer(SwaggerUiConfigParameters swaggerUiConfigParameters, SpringDocConfigProperties springDocConfigProperties, SwaggerIndexTransformer swaggerIndexTransformer) {
        this.swaggerPath = swaggerUiConfigParameters.getPath();
        this.webJarsPrefixUrl = springDocConfigProperties.getWebjars().getPrefix();
        this.swaggerIndexTransformer = swaggerIndexTransformer;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        if (this.swaggerPath.contains("/")) {
            uiRootPath.append(this.swaggerPath, 0, this.swaggerPath.lastIndexOf(47));
        }
        registry.addResourceHandler(new String[]{uiRootPath + this.webJarsPrefixUrl + "/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).resourceChain(false).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }
}

