/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.util.List;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerResourceResolver;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SwaggerResourceResolver
extends AbstractSwaggerResourceResolver
implements ResourceResolver {
    public SwaggerResourceResolver(SwaggerUiConfigProperties swaggerUiConfigProperties) {
        super(swaggerUiConfigProperties);
    }

    public Mono<Resource> resolveResource(ServerWebExchange exchange, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveResource(exchange, requestPath, locations).switchIfEmpty(Mono.defer(() -> {
            String webJarsResourcePath = this.findWebJarResourcePath(requestPath);
            if (webJarsResourcePath != null) {
                return chain.resolveResource(exchange, webJarsResourcePath, locations);
            }
            return Mono.empty();
        }));
    }

    public Mono<String> resolveUrlPath(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations).switchIfEmpty(Mono.defer(() -> {
            String webJarResourcePath = this.findWebJarResourcePath(resourceUrlPath);
            if (webJarResourcePath != null) {
                return chain.resolveUrlPath(webJarResourcePath, locations);
            }
            return Mono.empty();
        }));
    }
}

