/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.springframework.batch.admin.service.FileInfo;
import org.springframework.batch.admin.service.FileService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MessageEndpoint
public class StringToFileAdapter
implements InitializingBean {
    private FileService fileService;

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public void afterPropertiesSet() {
        Assert.state((this.fileService != null ? 1 : 0) != 0, (String)"FileService must be provided");
    }

    @ServiceActivator
    public Collection<FileInfo> convert(String request) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("Null input data");
        }
        String path = "upload.txt";
        FileInfo dest = this.fileService.createFile(path);
        FileUtils.writeStringToFile((File)this.fileService.getResource(dest.getPath()).getFile(), (String)request);
        this.fileService.publish(dest);
        return Arrays.asList(dest);
    }
}

