/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.jmx;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.jmx.SimpleJobExecutionMetrics;
import org.springframework.batch.admin.jmx.SimpleStepExecutionMetrics;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.context.SmartLifecycle;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.MetricType;
import org.springframework.util.Assert;

@ManagedResource
public class BatchMBeanExporter
extends MBeanExporter
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(BatchMBeanExporter.class);
    public static final String DEFAULT_DOMAIN = "org.springframework.batch";
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running;
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private Set<String> stepKeys = new HashSet<String>();
    private Set<String> jobKeys = new HashSet<String>();
    private final AnnotationJmxAttributeSource attributeSource = new AnnotationJmxAttributeSource();
    private JobService jobService;
    private String domain = "org.springframework.batch";

    public BatchMBeanExporter() {
        this.setAutodetect(false);
        this.setNamingStrategy((ObjectNamingStrategy)new MetadataNamingStrategy((JmxAttributeSource)this.attributeSource));
        this.setAssembler((MBeanInfoAssembler)new MetadataMBeanInfoAssembler((JmxAttributeSource)this.attributeSource));
    }

    public void setDefaultDomain(String domain) {
        this.domain = domain;
    }

    protected String getDefaultDomain() {
        return this.domain;
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }

    public void afterPropertiesSet() {
        Assert.state((this.jobService != null ? 1 : 0) != 0, (String)"A JobService must be provided");
        super.afterPropertiesSet();
    }

    protected void registerBeans() {
    }

    private void registerSteps() {
        for (String jobName : this.jobService.listJobs(0, Integer.MAX_VALUE)) {
            Collection<Object> jobExecutions = Collections.emptySet();
            try {
                jobExecutions = this.jobService.listJobExecutionsForJob(jobName, 0, 1);
            }
            catch (NoSuchJobException e) {
                logger.error((Object)"Job listed but does not exist", (Throwable)e);
            }
            for (JobExecution jobExecution : jobExecutions) {
                for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                    String stepName = stepExecution.getStepName();
                    String stepKey = String.format("%s/%s", jobName, stepName);
                    String beanKey = this.getBeanKeyForStepExecution(jobName, stepName);
                    if (this.stepKeys.contains(stepKey)) continue;
                    this.stepKeys.add(stepKey);
                    logger.info((Object)("Registering step execution " + stepKey));
                    this.registerBeanNameOrInstance(new SimpleStepExecutionMetrics(this.jobService, jobName, stepName), beanKey);
                }
            }
        }
    }

    private void registerJobs() {
        for (String jobName : this.jobService.listJobs(0, Integer.MAX_VALUE)) {
            if (this.jobKeys.contains(jobName)) continue;
            this.jobKeys.add(jobName);
            logger.info((Object)("Registering job execution " + jobName));
            this.registerBeanNameOrInstance(new SimpleJobExecutionMetrics(this.jobService, jobName), this.getBeanKeyForJobExecution(jobName));
        }
    }

    protected String getBeanKeyForJobExecution(String jobName) {
        return String.format("%s:type=JobExecution,name=%s", this.domain, jobName);
    }

    protected String getBeanKeyForStepExecution(String jobName, String stepName) {
        return String.format("%s:type=JobExecution,name=%s,step=%s", this.domain, jobName, stepName);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Step Count")
    public int getStepCount() {
        this.registerSteps();
        return this.stepKeys.size();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Job Count")
    public int getJobCount() {
        this.registerJobs();
        return this.jobKeys.size();
    }

    @ManagedAttribute
    public String[] getJobNames() {
        return this.jobKeys.toArray(new String[0]);
    }

    @ManagedAttribute
    public String[] getStepNames() {
        return this.stepKeys.toArray(new String[0]);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Job Execution Failure Count")
    public int getJobExecutionFailureCount() {
        Collection<JobExecution> jobExecutions;
        int count = 0;
        int start = 0;
        int pageSize = 100;
        do {
            jobExecutions = this.jobService.listJobExecutions(start, pageSize);
            start += pageSize;
            for (JobExecution jobExecution : jobExecutions) {
                if (!jobExecution.getStatus().isUnsuccessful()) continue;
                ++count;
            }
        } while (!jobExecutions.isEmpty());
        return count;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Job Execution Count")
    public int getJobExecutionCount() {
        return this.jobService.countJobExecutions();
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("started " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("stopped " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected void doStop() {
        this.unregisterBeans();
        this.jobKeys.clear();
        this.stepKeys.clear();
    }

    protected void doStart() {
        this.registerJobs();
        this.registerSteps();
    }
}

