/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class SimpleEhCacheInterceptor
implements MethodInterceptor,
InitializingBean,
DisposableBean,
Lifecycle {
    private Cache cache;
    private CacheManager manager;
    private volatile boolean caching = true;
    private long timeout = 60L;
    private String name = "simple";

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setCacheName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        this.manager = CacheManager.create();
        this.cache = new Cache(this.name, 0, true, false, this.timeout, 0L);
        this.manager.addCache(this.cache);
    }

    public void destroy() throws Exception {
        if (this.manager != null) {
            this.manager.removalAll();
            this.manager.shutdown();
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Serializable key = this.getKey(invocation);
        Element element = this.cache.get(key);
        Object value = null;
        if (this.caching && (element == null || element.isExpired())) {
            this.cache.remove(key);
            Serializable old = element == null ? null : element.getValue();
            value = invocation.proceed();
            if (this.cacheable(value, old)) {
                this.cache.putIfAbsent(new Element((Object)key, value));
            }
        } else {
            value = element.getObjectValue();
        }
        return value;
    }

    private boolean cacheable(Object value, Object old) {
        if (value == null) {
            return false;
        }
        if (old != null) {
            return true;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return false;
        }
        if (value instanceof Map && ((Map)value).isEmpty()) {
            return false;
        }
        return !value.getClass().isArray() || ((Object[])value).length != 0;
    }

    private Serializable getKey(MethodInvocation invocation) {
        return invocation.getMethod().getName() + Arrays.asList(invocation.getArguments());
    }

    @ManagedOperation
    public void start() {
        this.caching = true;
    }

    @ManagedOperation
    public void stop() {
        this.caching = false;
    }

    @ManagedAttribute
    public boolean isRunning() {
        return this.caching;
    }
}

