/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.admin.web.JobInfo;
import org.springframework.batch.admin.web.JobInstanceInfo;
import org.springframework.batch.admin.web.JobParametersExtractor;
import org.springframework.batch.admin.web.StepExecutionInfo;
import org.springframework.batch.admin.web.TableUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.launch.NoSuchJobInstanceException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class JobExecutionController {
    private static Log logger = LogFactory.getLog(JobExecutionController.class);
    private JobService jobService;
    private JobParametersExtractor jobParametersExtractor = new JobParametersExtractor();
    private TimeZone timeZone = TimeZone.getDefault();

    @Autowired(required=false)
    @Qualifier(value="userTimeZone")
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Autowired
    public JobExecutionController(JobService jobService) {
        this.jobService = jobService;
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}"}, method={RequestMethod.DELETE})
    public String stop(Model model, @ModelAttribute(value="stopRequest") StopRequest stopRequest, Errors errors, @PathVariable Long jobExecutionId) {
        stopRequest.jobExecutionId = jobExecutionId;
        try {
            JobExecution jobExecution = this.jobService.stop(jobExecutionId);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "No job exection with id=" + jobExecutionId);
        }
        catch (JobExecutionNotRunningException e) {
            errors.reject("job.execution.not.running", "Job exection with id=" + jobExecutionId + " is not running.");
            try {
                JobExecution jobExecution = this.jobService.getJobExecution(jobExecutionId);
                model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
            }
            catch (NoSuchJobExecutionException e1) {
                // empty catch block
            }
        }
        return "jobs/execution";
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}"}, method={RequestMethod.DELETE}, params={"abandon"})
    public String abandon(Model model, @ModelAttribute(value="stopRequest") StopRequest stopRequest, Errors errors, @PathVariable Long jobExecutionId) {
        stopRequest.jobExecutionId = jobExecutionId;
        try {
            JobExecution jobExecution = this.jobService.abandon(jobExecutionId);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "No job exection with id=" + jobExecutionId);
        }
        catch (JobExecutionAlreadyRunningException e) {
            errors.reject("job.execution.running", "Job exection with id=" + jobExecutionId + " is running.");
            try {
                JobExecution jobExecution = this.jobService.getJobExecution(jobExecutionId);
                model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
            }
            catch (NoSuchJobExecutionException e1) {
                // empty catch block
            }
        }
        return "jobs/execution";
    }

    @RequestMapping(value={"/jobs/executions", "/jobs/executions.*"}, method={RequestMethod.GET})
    @ModelAttribute(value="jobExecutions")
    public Collection<JobExecutionInfo> list(ModelMap model, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        int total = this.jobService.countJobExecutions();
        TableUtils.addPagination((Map<String, Object>)model, total, startJobExecution, pageSize, "JobExecution");
        ArrayList<JobExecutionInfo> result = new ArrayList<JobExecutionInfo>();
        for (JobExecution jobExecution : this.jobService.listJobExecutions(startJobExecution, pageSize)) {
            result.add(new JobExecutionInfo(jobExecution, this.timeZone));
        }
        return result;
    }

    @RequestMapping(value={"/jobs/{jobName}/{jobInstanceId}/executions", "/jobs/{jobName}/{jobInstanceId}"}, method={RequestMethod.GET})
    public String listForInstance(Model model, @PathVariable String jobName, @PathVariable long jobInstanceId, @ModelAttribute(value="date") Date date, Errors errors) {
        JobInstance jobInstance = null;
        try {
            jobInstance = this.jobService.getJobInstance(jobInstanceId);
            if (!jobInstance.getJobName().equals(jobName)) {
                errors.reject("wrong.job.name", new Object[]{jobInstanceId, jobInstance.getJobName(), jobName}, "The JobInstance with id=" + jobInstanceId + " has the wrong name (" + jobInstance.getJobName() + " not " + jobName);
            }
        }
        catch (NoSuchJobInstanceException e) {
            errors.reject("no.such.job.instance", new Object[]{jobInstanceId}, "There is no such job instance (" + jobInstanceId + ")");
        }
        if (!(jobInstance == null || errors != null && errors.hasErrors())) {
            ArrayList<JobExecutionInfo> result = new ArrayList<JobExecutionInfo>();
            try {
                Collection<JobExecution> jobExecutions = this.jobService.getJobExecutionsForJobInstance(jobName, jobInstanceId);
                for (JobExecution jobExecution : jobExecutions) {
                    result.add(new JobExecutionInfo(jobExecution, this.timeZone));
                }
                JobInstanceInfo jobInstanceInfo = new JobInstanceInfo(jobInstance, jobExecutions);
                model.addAttribute((Object)jobInstanceInfo);
                model.addAttribute("jobParameters", (Object)this.jobParametersExtractor.fromJobParameters(jobInstance.getJobParameters()));
            }
            catch (NoSuchJobException e) {
                errors.reject("no.such.job", new Object[]{jobName}, "There is no such job (" + jobName + ")");
            }
            model.addAttribute((Object)new JobInfo(jobName, result.size(), jobInstanceId, this.jobService.isLaunchable(jobName), this.jobService.isIncrementable(jobName)));
            model.addAttribute("jobExecutions", result);
        }
        return "jobs/executions";
    }

    @RequestMapping(value={"/jobs/{jobName}/{jobInstanceId}/executions"}, method={RequestMethod.POST})
    public String restart(Model model, @PathVariable String jobName, @PathVariable long jobInstanceId, @ModelAttribute(value="date") Date date, Errors errors) {
        try {
            Collection<JobExecution> jobExecutions = this.jobService.getJobExecutionsForJobInstance(jobName, jobInstanceId);
            model.addAttribute((Object)new JobInfo(jobName, jobExecutions.size() + 1));
            JobExecution jobExecution = jobExecutions.iterator().next();
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
            Long jobExecutionId = jobExecution.getId();
            try {
                jobExecution = this.jobService.restart(jobExecutionId);
                model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
            }
            catch (NoSuchJobExecutionException e) {
                errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "There is no such job execution (" + jobExecutionId + ")");
            }
            catch (JobExecutionAlreadyRunningException e) {
                errors.reject("job.execution.already.running", new Object[]{jobExecutionId}, "This job execution is already running (" + jobExecutionId + ")");
            }
            catch (JobRestartException e) {
                errors.reject("job.restart.exception", new Object[]{jobName}, "There was a problem restarting the job (" + jobName + ")");
            }
            catch (JobInstanceAlreadyCompleteException e) {
                errors.reject("job.instance.already.complete", new Object[]{jobName}, "The job instance is already complete for (" + jobName + "). Use different job parameters to launch it again.");
            }
            catch (JobParametersInvalidException e) {
                errors.reject("job.parameters.invalid", new Object[]{jobName}, "The job parameters are invalid according to the job (" + jobName + ")");
            }
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "There is no such job (" + jobName + ")");
        }
        return "jobs/execution";
    }

    @RequestMapping(value={"/jobs/executions"}, method={RequestMethod.DELETE})
    @ModelAttribute(value="jobExecutions")
    public Collection<JobExecutionInfo> stopAll(ModelMap model, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        model.addAttribute("stoppedCount", (Object)this.jobService.stopAll());
        return this.list(model, startJobExecution, pageSize);
    }

    @RequestMapping(value={"/jobs/{jobName}/executions"}, method={RequestMethod.GET})
    public String listForJob(ModelMap model, @PathVariable String jobName, @ModelAttribute(value="date") Date date, Errors errors, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        int total = startJobExecution;
        try {
            total = this.jobService.countJobExecutionsForJob(jobName);
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "There is no such job (" + jobName + ")");
            logger.warn((Object)("Could not locate Job with name=" + jobName));
            return "jobs/executions";
        }
        TableUtils.addPagination((Map<String, Object>)model, total, startJobExecution, pageSize, "JobExecution");
        ArrayList<JobExecutionInfo> result = new ArrayList<JobExecutionInfo>();
        try {
            for (JobExecution jobExecution : this.jobService.listJobExecutionsForJob(jobName, startJobExecution, pageSize)) {
                result.add(new JobExecutionInfo(jobExecution, this.timeZone));
            }
            int count = this.jobService.countJobExecutionsForJob(jobName);
            model.addAttribute((Object)new JobInfo(jobName, count, null, this.jobService.isLaunchable(jobName), this.jobService.isIncrementable(jobName)));
            model.addAttribute("jobExecutions", result);
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "There is no such job (" + jobName + ")");
            logger.warn((Object)("Could not locate Job with name=" + jobName));
        }
        return "jobs/executions";
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}"}, method={RequestMethod.GET})
    public String detail(Model model, @PathVariable Long jobExecutionId, @ModelAttribute(value="date") Date date, Errors errors) {
        try {
            JobExecution jobExecution = this.jobService.getJobExecution(jobExecutionId);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
            String jobName = jobExecution.getJobInstance().getJobName();
            HashSet<String> stepNames = new HashSet<String>(this.jobService.getStepNamesForJob(jobName));
            ArrayList stepExecutions = new ArrayList(jobExecution.getStepExecutions());
            ArrayList<StepExecutionInfo> stepExecutionInfos = new ArrayList<StepExecutionInfo>();
            for (StepExecution stepExecution : stepExecutions) {
                stepExecutionInfos.add(new StepExecutionInfo(stepExecution, this.timeZone));
            }
            for (String name : stepNames) {
                boolean found = false;
                Iterator iterator = stepExecutions.iterator();
                while (iterator.hasNext()) {
                    StepExecution stepExecution = (StepExecution)iterator.next();
                    if (!stepExecution.getStepName().equals(name)) continue;
                    iterator.remove();
                    found = true;
                }
                if (found) continue;
                stepExecutionInfos.add(new StepExecutionInfo(jobName, jobExecutionId, name, this.timeZone));
            }
            model.addAttribute("stepExecutionInfos", stepExecutionInfos);
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "There is no such job execution (" + jobExecutionId + ")");
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobExecutionId}, "There is no such job with exeuction id (" + jobExecutionId + ")");
        }
        return "jobs/execution";
    }

    public static class StopRequest {
        private Long jobExecutionId;

        public Long getJobExecutionId() {
            return this.jobExecutionId;
        }

        public void setJobExecutionId(Long jobExecutionId) {
            this.jobExecutionId = jobExecutionId;
        }
    }
}

