/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.Properties;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.support.PropertiesConverter;

public class JobParametersExtractor {
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public String fromJobParameters(JobParameters oldParameters) {
        String properties = PropertiesConverter.propertiesToString((Properties)this.converter.getProperties(oldParameters));
        if (properties.startsWith("#")) {
            properties = properties.substring(properties.indexOf(LINE_SEPARATOR) + LINE_SEPARATOR.length());
        }
        properties = properties.replace("\\:", ":");
        return properties;
    }

    public JobParameters fromString(String params) {
        Properties properties = PropertiesConverter.stringToProperties((String)params);
        return this.converter.getJobParameters(properties);
    }
}

