/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobParametersNotFoundException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.integration.launch.JobLaunchRequest;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class JobNameToJobRestartRequestAdapter {
    private JobLocator jobLocator;
    private JobExplorer jobExplorer;

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    @ServiceActivator
    public JobLaunchRequest adapt(String jobName) throws NoSuchJobException, JobParametersNotFoundException {
        jobName = jobName.trim();
        Job job = this.jobLocator.getJob(jobName);
        JobParameters jobParameters = this.getLastFailedJobParameters(jobName);
        return new JobLaunchRequest(job, jobParameters);
    }

    private JobParameters getLastFailedJobParameters(String jobName) throws JobParametersNotFoundException {
        int start = 0;
        int count = 100;
        List lastInstances = this.jobExplorer.getJobInstances(jobName, start, count);
        JobParameters jobParameters = null;
        if (lastInstances.isEmpty()) {
            throw new JobParametersNotFoundException("No job instance found for job=" + jobName);
        }
        while (!lastInstances.isEmpty()) {
            for (JobInstance jobInstance : lastInstances) {
                JobExecution jobExecution;
                List jobExecutions = this.jobExplorer.getJobExecutions(jobInstance);
                if (jobExecutions == null || jobExecutions.isEmpty() || !(jobExecution = (JobExecution)jobExecutions.get(jobExecutions.size() - 1)).getStatus().isGreaterThan(BatchStatus.STOPPING)) continue;
                jobParameters = jobInstance.getJobParameters();
                break;
            }
            if (jobParameters != null) break;
            lastInstances = this.jobExplorer.getJobInstances(jobName, start += count, count);
        }
        if (jobParameters == null) {
            throw new JobParametersNotFoundException("No failed or stopped execution found for job=" + jobName);
        }
        return jobParameters;
    }
}

