/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.service.FileInfo;
import org.springframework.batch.admin.service.FileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

@Controller
public class FileController {
    private static Log logger = LogFactory.getLog(FileController.class);
    private FileService fileService;

    @Autowired
    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    @RequestMapping(value={"/files"}, method={RequestMethod.POST})
    public String uploadRequest(@RequestParam String path, @RequestParam MultipartFile file, ModelMap model, @RequestParam(defaultValue="0") int startFile, @RequestParam(defaultValue="20") int pageSize, @ModelAttribute(value="date") Date date, Errors errors) throws Exception {
        return this.upload(path, file, model, startFile, pageSize, date, errors);
    }

    @RequestMapping(value={"/files/{path}"}, method={RequestMethod.POST})
    public String upload(@PathVariable String path, @RequestParam MultipartFile file, ModelMap model, @RequestParam(defaultValue="0") int startFile, @RequestParam(defaultValue="20") int pageSize, @ModelAttribute(value="date") Date date, Errors errors) throws Exception {
        String originalFilename = file.getOriginalFilename();
        if (file.isEmpty()) {
            errors.reject("file.upload.empty", new Object[]{originalFilename}, "File upload was empty for filename=[" + HtmlUtils.htmlEscape((String)originalFilename) + "]");
            this.list(model, startFile, pageSize);
            return "files";
        }
        try {
            FileInfo dest = this.fileService.createFile(path + "/" + originalFilename);
            file.transferTo(this.fileService.getResource(dest.getPath()).getFile());
            this.fileService.publish(dest);
            model.put((Object)"uploaded", (Object)dest.getPath());
        }
        catch (IOException e) {
            errors.reject("file.upload.failed", new Object[]{originalFilename}, "File upload failed for " + HtmlUtils.htmlEscape((String)originalFilename));
        }
        catch (Exception e) {
            String message = "File upload failed downstream processing for " + HtmlUtils.htmlEscape((String)originalFilename);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)message, (Throwable)e);
            } else {
                logger.info((Object)message);
            }
            errors.reject("file.upload.failed.downstream", new Object[]{originalFilename}, message);
        }
        if (errors.hasErrors()) {
            this.list(model, startFile, pageSize);
            return "files";
        }
        return "redirect:files";
    }

    @RequestMapping(value={"/files"}, method={RequestMethod.GET})
    public void list(ModelMap model, @RequestParam(defaultValue="0") int startFile, @RequestParam(defaultValue="20") int pageSize) throws Exception {
        List<FileInfo> files = this.fileService.getFiles(startFile, pageSize);
        Collections.sort(files);
        model.put((Object)"files", files);
    }

    @RequestMapping(value={"/files/**"}, method={RequestMethod.GET})
    public String get(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestParam(defaultValue="0") int startFile, @RequestParam(defaultValue="20") int pageSize, @ModelAttribute(value="date") Date date, Errors errors) throws Exception {
        this.list(model, startFile, pageSize);
        String path = request.getPathInfo().substring("/files/".length());
        Resource file = this.fileService.getResource(path);
        if (file == null || !file.exists()) {
            errors.reject("file.download.missing", new Object[]{path}, "File download failed for missing file at path=" + HtmlUtils.htmlEscape((String)path));
            return "files";
        }
        response.setContentType("application/octet-stream");
        try {
            FileCopyUtils.copy((InputStream)file.getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            errors.reject("file.download.failed", new Object[]{path}, "File download failed for path=" + HtmlUtils.htmlEscape((String)path));
            logger.info((Object)("File download failed for path=" + path), (Throwable)e);
            return "files";
        }
        return null;
    }

    @RequestMapping(value={"/files"}, method={RequestMethod.DELETE})
    public String delete(ModelMap model, @RequestParam(defaultValue="**") String pattern) throws Exception {
        int deletedCount = this.fileService.delete(pattern);
        model.put((Object)"files", new ArrayList());
        model.put((Object)"deletedCount", (Object)deletedCount);
        return "redirect:files";
    }
}

