/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.StringUtils;

public class FileInfo
implements Comparable<FileInfo>,
Serializable {
    private static final String TIMESTAMP_PATTERN = ".*\\.[0-9]*\\.[0-9]*";
    private final String timestamp;
    private final String path;
    private final String shortPath;
    private final boolean local;

    public FileInfo(String path) {
        this(path, null, true);
    }

    public FileInfo(String path, String timestamp, boolean local) {
        this.path = path.replace("\\", "/");
        this.shortPath = this.extractPath(path, timestamp);
        this.timestamp = this.extractTimestamp(path, timestamp);
        this.local = local;
    }

    public FileInfo shortPath() {
        FileInfo info = new FileInfo(this.shortPath, this.timestamp, this.local);
        return info;
    }

    public String getPattern() {
        String prefix;
        if (this.path.matches(TIMESTAMP_PATTERN)) {
            return this.path;
        }
        String extension = StringUtils.getFilenameExtension((String)this.path);
        String string = prefix = extension == null ? this.path : this.path.substring(0, this.path.length() - extension.length() - 1);
        if (prefix.matches(TIMESTAMP_PATTERN)) {
            return this.path;
        }
        return prefix + ".*.*" + (extension == null ? "" : "." + extension);
    }

    private String extractPath(String path, String timestamp) {
        String prefix;
        if (path.matches(TIMESTAMP_PATTERN)) {
            return path.substring(0, path.length() - 16);
        }
        String extension = StringUtils.getFilenameExtension((String)path);
        String string = prefix = extension == null ? path : path.substring(0, path.length() - extension.length() - 1);
        if (prefix.matches(TIMESTAMP_PATTERN)) {
            return prefix.substring(0, prefix.length() - 16) + "." + extension;
        }
        return path;
    }

    private String extractTimestamp(String path, String timestamp) {
        String prefix;
        if (timestamp != null) {
            return timestamp;
        }
        if (path.matches(TIMESTAMP_PATTERN)) {
            return path.substring(path.length() - 15, path.length());
        }
        String extension = StringUtils.getFilenameExtension((String)path);
        String string = prefix = extension == null ? path : path.substring(0, path.length() - extension.length() - 1);
        if (prefix.matches(TIMESTAMP_PATTERN)) {
            return prefix.substring(prefix.length() - 15, prefix.length());
        }
        return new SimpleDateFormat("yyyyMMdd.HHmmss").format(new Date());
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        String prefix;
        if (this.path.matches(TIMESTAMP_PATTERN)) {
            return this.path;
        }
        String extension = StringUtils.getFilenameExtension((String)this.path);
        String string = prefix = extension == null ? this.path : this.path.substring(0, this.path.length() - extension.length() - 1);
        if (prefix.matches(TIMESTAMP_PATTERN)) {
            return this.path;
        }
        return prefix + this.getSuffix() + (extension == null ? "" : "." + extension);
    }

    private String getSuffix() {
        return "." + this.timestamp;
    }

    @Override
    public int compareTo(FileInfo o) {
        return this.shortPath.equals(o.shortPath) ? -this.timestamp.compareTo(o.timestamp) : this.path.compareTo(o.path);
    }

    public String toString() {
        return "FileInfo [path=" + this.path + ", timestamp=" + this.timestamp + ", local=" + this.local + "]";
    }
}

