/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.admin.web.util.ResourceInfo;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

@Controller
public class HomeController
implements ApplicationContextAware,
InitializingBean {
    private static Log logger = LogFactory.getLog(HomeController.class);
    private ApplicationContext applicationContext;
    private Set<String> urls;
    private List<ResourceInfo> defaultResources;
    private List<ResourceInfo> jsonResources;
    private String servletPath;
    private Properties defaultProperties = null;
    private Properties jsonProperties = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setDefaultResources(Properties defaultResources) {
        this.defaultProperties = defaultResources;
    }

    public void setJsonResources(Properties jsonResources) {
        this.jsonProperties = jsonResources;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.defaultProperties == null || this.defaultProperties.isEmpty()) {
            this.findResources();
        } else {
            this.urls = this.buildUrlsFromProperties(this.defaultProperties);
            this.defaultResources = this.buildResourcesFromProperties(this.defaultProperties, this.defaultProperties);
            this.jsonResources = this.buildResourcesFromProperties(this.jsonProperties, this.defaultProperties);
        }
    }

    private List<ResourceInfo> buildResourcesFromProperties(Properties properties, Properties defaults) {
        TreeSet<ResourceInfo> resources = new TreeSet<ResourceInfo>();
        if (properties == null) {
            if (defaults == null) {
                return new ArrayList<ResourceInfo>();
            }
            properties = defaults;
        }
        Enumeration<?> iterator = properties.propertyNames();
        while (iterator.hasMoreElements()) {
            String key = (String)iterator.nextElement();
            String method = key.substring(0, key.indexOf("/"));
            String url = key.substring(key.indexOf("/"));
            String description = properties.getProperty(key, defaults.getProperty(key));
            resources.add(new ResourceInfo(url, RequestMethod.valueOf((String)method), description));
        }
        return new ArrayList<ResourceInfo>(resources);
    }

    private Set<String> buildUrlsFromProperties(Properties properties) {
        HashSet<String> urls = new HashSet<String>();
        if (properties == null) {
            return urls;
        }
        Enumeration<?> iterator = properties.propertyNames();
        while (iterator.hasMoreElements()) {
            String key = (String)iterator.nextElement();
            String url = key.substring(key.indexOf("/"));
            urls.add(url);
        }
        return urls;
    }

    private void findResources() {
        HashMap<String, Object> handlerMap = new HashMap<String, Object>();
        DefaultAnnotationHandlerMapping annotationMapping = new DefaultAnnotationHandlerMapping();
        annotationMapping.setApplicationContext(this.applicationContext);
        annotationMapping.initApplicationContext();
        handlerMap.putAll(annotationMapping.getHandlerMap());
        BeanNameUrlHandlerMapping beanMapping = new BeanNameUrlHandlerMapping();
        beanMapping.setApplicationContext(this.applicationContext);
        beanMapping.initApplicationContext();
        handlerMap.putAll(beanMapping.getHandlerMap());
        this.urls = this.findUniqueUrls(handlerMap.keySet());
        this.defaultResources = this.findMethods(handlerMap, this.urls);
        this.jsonResources = new ArrayList<ResourceInfo>();
        Iterator<ResourceInfo> iterator = this.defaultResources.iterator();
        while (iterator.hasNext()) {
            ResourceInfo info = iterator.next();
            if (!info.getUrl().endsWith(".json")) continue;
            iterator.remove();
            this.jsonResources.add(info);
        }
    }

    private List<ResourceInfo> findMethods(Map<String, Object> handlerMap, Set<String> urls) {
        TreeSet<ResourceInfo> result = new TreeSet<ResourceInfo>();
        for (String key : urls) {
            Object handler = handlerMap.get(key);
            Class handlerType = ClassUtils.getUserClass((Object)handler);
            HandlerMethodResolver resolver = new HandlerMethodResolver();
            resolver.init(handlerType);
            String[] typeMappings = null;
            RequestMapping typeMapping = (RequestMapping)AnnotationUtils.findAnnotation((Class)handlerType, RequestMapping.class);
            if (typeMapping != null) {
                typeMappings = typeMapping.value();
            }
            Set handlerMethods = resolver.getHandlerMethods();
            for (Method method : handlerMethods) {
                RequestMapping mapping = method.getAnnotation(RequestMapping.class);
                HashSet<String> computedMappings = new HashSet<String>();
                if (typeMappings != null) {
                    computedMappings.addAll(Arrays.asList(typeMappings));
                }
                for (String path : mapping.value()) {
                    if (typeMappings != null) {
                        for (String parent : computedMappings) {
                            if (parent.endsWith("/")) {
                                parent = parent.substring(0, parent.length() - 1);
                            }
                            computedMappings.add(parent + path);
                        }
                        continue;
                    }
                    computedMappings.add(path);
                }
                logger.debug((Object)("Analysing mappings for method:" + method.getName() + ", key:" + key + ", computed mappings: " + computedMappings));
                if (!computedMappings.contains(key)) continue;
                RequestMethod[] methods = mapping.method();
                if (methods != null && methods.length > 0) {
                    for (RequestMethod requestMethod : methods) {
                        logger.debug((Object)("Added explicit mapping for path=" + key + "to RequestMethod=" + requestMethod));
                        result.add(new ResourceInfo(key, requestMethod));
                    }
                    continue;
                }
                logger.debug((Object)("Added implicit mapping for path=" + key + "to RequestMethod=GET"));
                result.add(new ResourceInfo(key, RequestMethod.GET));
            }
            if (!handlerMethods.isEmpty()) continue;
            result.add(new ResourceInfo(key, RequestMethod.GET));
        }
        return new ArrayList<ResourceInfo>(result);
    }

    private Set<String> findUniqueUrls(Collection<String> inputs) {
        HashSet<String> result = new HashSet<String>(inputs);
        for (String url : inputs) {
            String extended = url + ".*";
            if (inputs.contains(extended)) {
                result.remove(extended);
            }
            if (!inputs.contains(extended = url + "/")) continue;
            result.remove(extended);
        }
        return result;
    }

    @RequestMapping(value={"/", "/home"}, method={RequestMethod.GET})
    public String getResources(HttpServletRequest request, ModelMap model) {
        String servletPath = this.servletPath;
        if (servletPath == null) {
            servletPath = new UrlPathHelper().getServletPath(request);
        }
        model.addAttribute("servletPath", (Object)servletPath);
        ArrayList<ResourceInfo> resources = new ArrayList<ResourceInfo>();
        if (!request.getRequestURI().endsWith(".json")) {
            resources.addAll(this.defaultResources);
        }
        resources.addAll(this.jsonResources);
        model.addAttribute("resources", resources);
        return "home";
    }

    public Set<String> getUrlPatterns() {
        return this.urls;
    }
}

