/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.ObjectStreamException;
import java.io.Serializable;

public class BatchStatus
implements Serializable {
    private static final long serialVersionUID = 1634960297477743037L;
    private final String name;
    public static final BatchStatus COMPLETED = new BatchStatus("COMPLETED");
    public static final BatchStatus STARTED = new BatchStatus("STARTED");
    public static final BatchStatus STARTING = new BatchStatus("STARTING");
    public static final BatchStatus FAILED = new BatchStatus("FAILED");
    public static final BatchStatus STOPPING = new BatchStatus("STOPPING");
    public static final BatchStatus STOPPED = new BatchStatus("STOPPED");
    public static final BatchStatus UNKNOWN = new BatchStatus("UNKNOWN");
    private static final BatchStatus[] VALUES = new BatchStatus[]{STARTING, STARTED, COMPLETED, FAILED, STOPPING, STOPPED, UNKNOWN};

    private BatchStatus(String name) {
        this.name = name;
    }

    private Object readResolve() throws ObjectStreamException {
        return BatchStatus.getStatus(this.name);
    }

    public String toString() {
        return this.name;
    }

    public static BatchStatus getStatus(String statusAsString) {
        if (statusAsString == null) {
            return null;
        }
        String upperCaseStatusAsString = statusAsString.toUpperCase();
        for (int i = 0; i < VALUES.length; ++i) {
            if (!VALUES[i].toString().equals(upperCaseStatusAsString)) continue;
            return VALUES[i];
        }
        throw new IllegalArgumentException("The string did not match a valid status.");
    }
}

