/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import org.springframework.batch.core.StepExecution;

public class StepContribution {
    private int itemCount = 0;
    private int parentSkipCount;
    private int commitCount;
    private int skipCount;
    private int readSkipCount;

    public StepContribution(StepExecution execution) {
        this.parentSkipCount = execution.getSkipCount();
    }

    public void incrementItemCount() {
        ++this.itemCount;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void incrementCommitCount() {
        ++this.commitCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public int getStepSkipCount() {
        return this.readSkipCount + this.skipCount + this.parentSkipCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void incrementSkipCount() {
        ++this.skipCount;
    }

    public void incrementReadSkipCount() {
        ++this.readSkipCount;
    }

    public int getReadSkipCount() {
        return this.readSkipCount;
    }

    public void combineSkipCounts() {
        this.skipCount += this.readSkipCount;
        this.readSkipCount = 0;
    }

    public String toString() {
        return "[StepContribution: items=" + this.itemCount + ", commits=" + this.commitCount + ", readSkips=" + this.readSkipCount + ", skips=" + this.skipCount + "]";
    }
}

