/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

public class CompositeExecutionJobListener
implements JobExecutionListener {
    private List listeners = new ArrayList();

    public void setListeners(JobExecutionListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(JobExecutionListener jobExecutionListener) {
        if (!this.listeners.contains(jobExecutionListener)) {
            this.listeners.add(jobExecutionListener);
        }
    }

    public void afterJob(JobExecution jobExecution) {
        ListIterator iterator = this.listeners.listIterator();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.afterJob(jobExecution);
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        ListIterator iterator = this.listeners.listIterator();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.beforeJob(jobExecution);
        }
    }

    public void onError(JobExecution jobExecution, Throwable e) {
        ListIterator iterator = this.listeners.listIterator();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.onError(jobExecution, e);
        }
    }

    public void onInterrupt(JobExecution jobExecution) {
        ListIterator iterator = this.listeners.listIterator();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.onInterrupt(jobExecution);
        }
    }
}

