/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ItemReadListener;

public class CompositeItemReadListener
implements ItemReadListener {
    private List listeners = new ArrayList();

    public void setListeners(ItemReadListener[] itemReadListeners) {
        this.listeners = Arrays.asList(itemReadListeners);
    }

    public void register(ItemReadListener itemReaderListener) {
        if (!this.listeners.contains(itemReaderListener)) {
            this.listeners.add(itemReaderListener);
        }
    }

    public void afterRead(Object item) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemReadListener listener = (ItemReadListener)iterator.next();
            listener.afterRead(item);
        }
    }

    public void beforeRead() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemReadListener listener = (ItemReadListener)iterator.next();
            listener.beforeRead();
        }
    }

    public void onReadError(Exception ex) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemReadListener listener = (ItemReadListener)iterator.next();
            listener.onReadError(ex);
        }
    }
}

