/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.repeat.ExitStatus;

public class CompositeSkipListener
implements SkipListener {
    private List listeners = new ArrayList();

    public void setListeners(SkipListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(SkipListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ExitStatus onErrorInStep(StepExecution stepExecution, Throwable e) {
        ExitStatus status = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            StepExecutionListener listener = (StepExecutionListener)iterator.next();
            ExitStatus close = listener.onErrorInStep(stepExecution, e);
            status = status != null ? status.and(close) : close;
        }
        return status;
    }

    public void onSkipInRead(Throwable t) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SkipListener listener = (SkipListener)iterator.next();
            listener.onSkipInRead(t);
        }
    }

    public void onSkipInWrite(Object item, Throwable t) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SkipListener listener = (SkipListener)iterator.next();
            listener.onSkipInWrite(item, t);
        }
    }
}

