/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.CompositeChunkListener;
import org.springframework.batch.core.listener.CompositeItemReadListener;
import org.springframework.batch.core.listener.CompositeItemWriteListener;
import org.springframework.batch.core.listener.CompositeSkipListener;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.repeat.ExitStatus;

public class MulticasterBatchListener
implements StepExecutionListener,
ChunkListener,
ItemReadListener,
ItemWriteListener,
SkipListener {
    private CompositeStepExecutionListener stepListener = new CompositeStepExecutionListener();
    private CompositeChunkListener chunkListener = new CompositeChunkListener();
    private CompositeItemReadListener itemReadListener = new CompositeItemReadListener();
    private CompositeItemWriteListener itemWriteListener = new CompositeItemWriteListener();
    private CompositeSkipListener skipListener = new CompositeSkipListener();

    public void setListeners(StepListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.register(listeners[i]);
        }
    }

    public void register(StepListener listener) {
        if (listener instanceof StepExecutionListener) {
            this.stepListener.register((StepExecutionListener)listener);
        }
        if (listener instanceof ChunkListener) {
            this.chunkListener.register((ChunkListener)listener);
        }
        if (listener instanceof ItemReadListener) {
            this.itemReadListener.register((ItemReadListener)listener);
        }
        if (listener instanceof ItemWriteListener) {
            this.itemWriteListener.register((ItemWriteListener)listener);
        }
        if (listener instanceof SkipListener) {
            this.skipListener.register((SkipListener)listener);
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return this.stepListener.afterStep(stepExecution);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepListener.beforeStep(stepExecution);
    }

    public ExitStatus onErrorInStep(StepExecution stepExecution, Throwable e) {
        return this.stepListener.onErrorInStep(stepExecution, e);
    }

    public void afterChunk() {
        this.chunkListener.afterChunk();
    }

    public void beforeChunk() {
        this.chunkListener.beforeChunk();
    }

    public void afterRead(Object item) {
        this.itemReadListener.afterRead(item);
    }

    public void beforeRead() {
        this.itemReadListener.beforeRead();
    }

    public void onReadError(Exception ex) {
        this.itemReadListener.onReadError(ex);
    }

    public void afterWrite(Object item) {
        this.itemWriteListener.afterWrite(item);
    }

    public void beforeWrite(Object item) {
        this.itemWriteListener.beforeWrite(item);
    }

    public void onWriteError(Exception ex, Object item) {
        this.itemWriteListener.onWriteError(ex, item);
    }

    public void onSkipInRead(Throwable t) {
        this.skipListener.onSkipInRead(t);
    }

    public void onSkipInWrite(Object item, Throwable t) {
        this.skipListener.onSkipInWrite(item, t);
    }
}

