/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.NoSuchObjectException;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class JdbcJobExecutionDao
extends AbstractJdbcBatchMetadataDao
implements JobExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)JdbcJobExecutionDao.class);
    private static final int EXIT_MESSAGE_LENGTH = 250;
    private static final String GET_JOB_EXECUTION_COUNT = "SELECT count(JOB_EXECUTION_ID) from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ?";
    private static final String SAVE_JOB_EXECUTION = "INSERT into %PREFIX%JOB_EXECUTION(JOB_EXECUTION_ID, JOB_INSTANCE_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, VERSION) values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CHECK_JOB_EXECUTION_EXISTS = "SELECT COUNT(*) FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID = ?";
    private static final String UPDATE_JOB_EXECUTION = "UPDATE %PREFIX%JOB_EXECUTION set START_TIME = ?, END_TIME = ?,  STATUS = ?, CONTINUABLE = ?, EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ? where JOB_EXECUTION_ID = ?";
    private static final String FIND_JOB_EXECUTIONS = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ?";
    private static final String GET_LAST_EXECUTION = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ? and START_TIME = (SELECT max(START_TIME) from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ?)";
    private DataFieldMaxValueIncrementer jobExecutionIncrementer;

    public List findJobExecutions(JobInstance job) {
        Assert.notNull((Object)job, (String)"Job cannot be null.");
        Assert.notNull((Object)job.getId(), (String)"Job Id cannot be null.");
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_EXECUTIONS), new Object[]{job.getId()}, (RowMapper)new JobExecutionRowMapper(job));
    }

    public int getJobExecutionCount(JobInstance jobInstance) {
        Long jobId = jobInstance.getId();
        Assert.notNull((Object)jobId, (String)"JobId cannot be null");
        Object[] parameters = new Object[]{jobId};
        return this.getJdbcTemplate().queryForInt(this.getQuery(GET_JOB_EXECUTION_COUNT), parameters);
    }

    public void saveJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        jobExecution.setId(new Long(this.jobExecutionIncrementer.nextLongValue()));
        Object[] parameters = new Object[]{jobExecution.getId(), jobExecution.getJobId(), jobExecution.getStartTime(), jobExecution.getEndTime(), jobExecution.getStatus().toString(), jobExecution.getExitStatus().isContinuable() ? "Y" : "N", jobExecution.getExitStatus().getExitCode(), jobExecution.getExitStatus().getExitDescription(), jobExecution.getVersion()};
        this.getJdbcTemplate().update(this.getQuery(SAVE_JOB_EXECUTION), parameters, new int[]{4, 4, 93, 93, 12, 1, 12, 12, 4});
    }

    private void validateJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution);
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution Job-Id cannot be null.");
        Assert.notNull((Object)jobExecution.getStatus(), (String)"JobExecution status cannot be null.");
    }

    public void updateJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        String exitDescription = jobExecution.getExitStatus().getExitDescription();
        if (exitDescription != null && exitDescription.length() > 250) {
            exitDescription = exitDescription.substring(0, 250);
            logger.debug((Object)("Truncating long message before update of JobExecution: " + jobExecution));
        }
        Object[] parameters = new Object[]{jobExecution.getStartTime(), jobExecution.getEndTime(), jobExecution.getStatus().toString(), jobExecution.getExitStatus().isContinuable() ? "Y" : "N", jobExecution.getExitStatus().getExitCode(), exitDescription, jobExecution.getVersion(), jobExecution.getId()};
        if (jobExecution.getId() == null) {
            throw new IllegalArgumentException("JobExecution ID cannot be null.  JobExecution must be saved before it can be updated.");
        }
        if (this.getJdbcTemplate().queryForInt(this.getQuery(CHECK_JOB_EXECUTION_EXISTS), new Object[]{jobExecution.getId()}) != 1) {
            throw new NoSuchObjectException("Invalid JobExecution, ID " + jobExecution.getId() + " not found.");
        }
        this.getJdbcTemplate().update(this.getQuery(UPDATE_JOB_EXECUTION), parameters, new int[]{93, 93, 12, 1, 12, 12, 4, 4});
    }

    public void setJobExecutionIncrementer(DataFieldMaxValueIncrementer jobExecutionIncrementer) {
        this.jobExecutionIncrementer = jobExecutionIncrementer;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.jobExecutionIncrementer);
    }

    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        Long id = jobInstance.getId();
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_LAST_EXECUTION), new Object[]{id, id}, (RowMapper)new JobExecutionRowMapper(jobInstance));
        Assert.state((executions.size() <= 1 ? 1 : 0) != 0, (String)"There must be at most one latest job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return (JobExecution)executions.get(0);
    }

    private static class JobExecutionRowMapper
    implements RowMapper {
        private JobInstance job;

        public JobExecutionRowMapper(JobInstance job) {
            this.job = job;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            JobExecution jobExecution = new JobExecution(this.job);
            jobExecution.setId(new Long(rs.getLong(1)));
            jobExecution.setStartTime(rs.getTimestamp(2));
            jobExecution.setEndTime(rs.getTimestamp(3));
            jobExecution.setStatus(BatchStatus.getStatus(rs.getString(4)));
            jobExecution.setExitStatus(new ExitStatus("Y".equals(rs.getString(5)), rs.getString(6), rs.getString(7)));
            return jobExecution;
        }
    }
}

