/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.util.Assert;

public class MapJobExecutionDao
implements JobExecutionDao {
    private static Map executionsById = TransactionAwareProxyFactory.createTransactionalMap();
    private static long currentId;

    public static void clear() {
        executionsById.clear();
    }

    public int getJobExecutionCount(JobInstance jobInstance) {
        int count = 0;
        Iterator iterator = executionsById.values().iterator();
        while (iterator.hasNext()) {
            JobExecution exec = (JobExecution)iterator.next();
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            ++count;
        }
        return count;
    }

    public void saveJobExecution(JobExecution jobExecution) {
        Assert.isTrue((jobExecution.getId() == null ? 1 : 0) != 0);
        Long newId = new Long(currentId++);
        jobExecution.setId(newId);
        jobExecution.incrementVersion();
        executionsById.put(newId, jobExecution);
    }

    public List findJobExecutions(JobInstance jobInstance) {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        Iterator iterator = executionsById.values().iterator();
        while (iterator.hasNext()) {
            JobExecution exec = (JobExecution)iterator.next();
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            executions.add(exec);
        }
        return executions;
    }

    public void updateJobExecution(JobExecution jobExecution) {
        Long id = jobExecution.getId();
        Assert.notNull((Object)id, (String)"JobExecution is expected to have an id (should be saved already)");
        Assert.notNull(executionsById.get(id), (String)"JobExecution must already be saved");
        jobExecution.incrementVersion();
        executionsById.put(id, jobExecution);
    }

    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        JobExecution lastExec = null;
        Iterator iterator = executionsById.values().iterator();
        while (iterator.hasNext()) {
            JobExecution exec = (JobExecution)iterator.next();
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            if (lastExec == null) {
                lastExec = exec;
            }
            if (lastExec.getStartTime().getTime() >= exec.getStartTime().getTime()) continue;
            lastExec = exec;
        }
        return lastExec;
    }
}

