/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.util.Assert;

public class MapJobInstanceDao
implements JobInstanceDao {
    private static Collection jobInstances = TransactionAwareProxyFactory.createTransactionalList();
    private long currentId = 0L;

    public static void clear() {
        jobInstances.clear();
    }

    public JobInstance createJobInstance(Job job, JobParameters jobParameters) {
        Assert.state((this.getJobInstance(job, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        JobInstance jobInstance = new JobInstance(new Long(this.currentId++), jobParameters, job);
        jobInstance.incrementVersion();
        jobInstances.add(jobInstance);
        return jobInstance;
    }

    public JobInstance getJobInstance(Job job, JobParameters jobParameters) {
        Iterator iterator = jobInstances.iterator();
        while (iterator.hasNext()) {
            JobInstance instance = (JobInstance)iterator.next();
            if (!instance.getJobName().equals(job.getName()) || !instance.getJobParameters().equals(jobParameters)) continue;
            return instance;
        }
        return null;
    }
}

