/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.resource;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.util.Assert;

public class StepExecutionPreparedStatementSetter
extends StepExecutionListenerSupport
implements PreparedStatementSetter,
InitializingBean {
    private List parameterKeys;
    private JobParameters jobParameters;

    public void setValues(PreparedStatement ps) throws SQLException {
        Map parameters = this.jobParameters.getParameters();
        for (int i = 0; i < this.parameterKeys.size(); ++i) {
            Object arg = parameters.get(this.parameterKeys.get(i));
            if (arg == null) {
                throw new IllegalStateException("No job parameter found for with key of: [" + this.parameterKeys.get(i) + "]");
            }
            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, arg);
        }
    }

    public void beforeStep(StepExecution stepExecution) {
        this.jobParameters = stepExecution.getJobParameters();
    }

    public void setParameterKeys(List parameterKeys) {
        this.parameterKeys = parameterKeys;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.parameterKeys, (String)"Parameters names must be provided");
    }
}

