/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step;

import org.springframework.batch.core.step.BackportConcurrentStepExecutionSynchronizer;
import org.springframework.batch.core.step.JdkConcurrentStepExecutionSynchronizer;
import org.springframework.batch.core.step.StepExecutionSynchronizer;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;

public class StepExecutionSynchronizerFactory {
    private static final boolean backportConcurrentAvailable = ClassUtils.isPresent((String)"edu.emory.mathcs.backport.java.util.concurrent.Semaphore", (ClassLoader)StepExecutionSynchronizerFactory.class.getClassLoader());
    private final StepExecutionSynchronizer synchronizer;

    public StepExecutionSynchronizerFactory() {
        if (JdkVersion.isAtLeastJava15()) {
            this.synchronizer = new JdkConcurrentStepExecutionSynchronizer();
        } else if (backportConcurrentAvailable) {
            this.synchronizer = new BackportConcurrentStepExecutionSynchronizer();
        } else {
            throw new IllegalStateException("Cannot create StepExecutionSynchronizer - neither JDK 1.5 nor backport-concurrent available on the classpath");
        }
    }

    public StepExecutionSynchronizer getStepExecutionSynchronizer() {
        return this.synchronizer;
    }
}

