/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.Step;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.core.step.item.SimpleItemHandler;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public abstract class AbstractStepFactoryBean
implements FactoryBean,
BeanNameAware {
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete;
    private ItemReader itemReader;
    private ItemWriter itemWriter;
    private PlatformTransactionManager transactionManager;
    private JobRepository jobRepository;
    private boolean singleton = true;

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setItemReader(ItemReader itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemWriter(ItemWriter itemWriter) {
        this.itemWriter = itemWriter;
    }

    protected ItemReader getItemReader() {
        return this.itemReader;
    }

    protected ItemWriter getItemWriter() {
        return this.itemWriter;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public final Object getObject() throws Exception {
        ItemOrientedStep step = new ItemOrientedStep(this.getName());
        this.applyConfiguration(step);
        return step;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        Assert.notNull((Object)this.getItemReader(), (String)"ItemReader must be provided");
        Assert.notNull((Object)this.getItemWriter(), (String)"ItemWriter must be provided");
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must be provided");
        Assert.notNull((Object)this.transactionManager, (String)"TransactionManager must be provided");
        step.setItemHandler(new SimpleItemHandler(this.itemReader, this.itemWriter));
        step.setTransactionManager(this.transactionManager);
        step.setJobRepository(this.jobRepository);
        step.setStartLimit(this.startLimit);
        step.setAllowStartIfComplete(this.allowStartIfComplete);
    }

    public Class getObjectType() {
        return Step.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }
}

