/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.CompositeChunkListener;
import org.springframework.batch.core.listener.CompositeItemReadListener;
import org.springframework.batch.core.listener.CompositeItemWriteListener;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.DelegatingItemReader;
import org.springframework.batch.item.support.DelegatingItemWriter;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.listener.RepeatListenerSupport;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.util.Assert;

class BatchListenerFactoryHelper {
    BatchListenerFactoryHelper() {
    }

    public ItemReader getItemReader(ItemReader itemReader, StepListener[] listeners) {
        final CompositeItemReadListener multicaster = new CompositeItemReadListener();
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (!(listener instanceof ItemReadListener)) continue;
            multicaster.register((ItemReadListener)listener);
        }
        itemReader = new DelegatingItemReader((ItemReader)itemReader){

            public Object read() throws Exception {
                try {
                    multicaster.beforeRead();
                    Object item = super.read();
                    multicaster.afterRead(item);
                    return item;
                }
                catch (Exception e) {
                    multicaster.onReadError(e);
                    throw e;
                }
            }
        };
        return itemReader;
    }

    public ItemWriter getItemWriter(ItemWriter itemWriter, StepListener[] listeners) {
        final CompositeItemWriteListener multicaster = new CompositeItemWriteListener();
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (!(listener instanceof ItemWriteListener)) continue;
            multicaster.register((ItemWriteListener)listener);
        }
        itemWriter = new DelegatingItemWriter((ItemWriter)itemWriter){

            public void write(Object item) throws Exception {
                try {
                    multicaster.beforeWrite(item);
                    super.write(item);
                    multicaster.afterWrite(item);
                }
                catch (Exception e) {
                    multicaster.onWriteError(e, item);
                    throw e;
                }
            }
        };
        return itemWriter;
    }

    public RepeatOperations addChunkListeners(RepeatOperations chunkOperations, StepListener[] listeners) {
        final CompositeChunkListener multicaster = new CompositeChunkListener();
        boolean hasChunkListener = false;
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (listener instanceof ChunkListener) {
                hasChunkListener = true;
            }
            if (!(listener instanceof ChunkListener)) continue;
            multicaster.register((ChunkListener)listener);
        }
        if (hasChunkListener) {
            Assert.state((boolean)(chunkOperations instanceof RepeatTemplate), (String)"Chunk operations is injected but not a RepeatTemplate, so chunk listeners cannot also be registered. Either inject a RepeatTemplate, or remove the ChunkListener.");
            RepeatTemplate stepTemplate = (RepeatTemplate)chunkOperations;
            stepTemplate.registerListener((RepeatListener)new RepeatListenerSupport(){

                public void open(RepeatContext context) {
                    multicaster.beforeChunk();
                }

                public void close(RepeatContext context) {
                    multicaster.afterChunk();
                }
            });
        }
        return chunkOperations;
    }

    public StepExecutionListener[] getStepListeners(StepListener[] listeners) {
        ArrayList<StepListener> list = new ArrayList<StepListener>();
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (!(listener instanceof StepExecutionListener)) continue;
            list.add(listener);
        }
        return list.toArray(new StepExecutionListener[list.size()]);
    }

    public SkipListener[] getSkipListeners(StepListener[] listeners) {
        ArrayList<StepListener> list = new ArrayList<StepListener>();
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (!(listener instanceof SkipListener)) continue;
            list.add(listener);
        }
        return list.toArray(new SkipListener[list.size()]);
    }
}

