/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.NoSuchJobException;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.StepExecutionSynchronizer;
import org.springframework.batch.core.step.StepExecutionSynchronizerFactory;
import org.springframework.batch.core.step.StepInterruptionPolicy;
import org.springframework.batch.core.step.ThreadStepInterruptionPolicy;
import org.springframework.batch.core.step.item.ItemHandler;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.CompositeItemStream;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ItemOrientedStep
extends AbstractStep {
    private static final Log logger = LogFactory.getLog((Class)ItemOrientedStep.class);
    public static final String JOB_INTERRUPTED = "JOB_INTERRUPTED";
    private RepeatOperations chunkOperations = new RepeatTemplate();
    private RepeatOperations stepOperations = new RepeatTemplate();
    private StepInterruptionPolicy interruptionPolicy = new ThreadStepInterruptionPolicy();
    private CompositeItemStream stream = new CompositeItemStream();
    private CompositeStepExecutionListener listener = new CompositeStepExecutionListener();
    private JobRepository jobRepository;
    private PlatformTransactionManager transactionManager;
    private ItemHandler itemHandler;
    private StepExecutionSynchronizer synchronizer = new StepExecutionSynchronizerFactory().getStepExecutionSynchronizer();

    public ItemOrientedStep(String name) {
        super(name);
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setItemHandler(ItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    public void setStreams(ItemStream[] streams) {
        for (int i = 0; i < streams.length; ++i) {
            this.registerStream(streams[i]);
        }
    }

    public void registerStream(ItemStream stream) {
        this.stream.register(stream);
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    public void registerStepExecutionListener(StepExecutionListener listener) {
        this.listener.register(listener);
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setChunkOperations(RepeatOperations chunkOperations) {
        this.chunkOperations = chunkOperations;
    }

    public void setInterruptionPolicy(StepInterruptionPolicy interruptionPolicy) {
        this.interruptionPolicy = interruptionPolicy;
    }

    public void setSynchronizer(StepExecutionSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    /*
     * Loose catch block
     */
    public void execute(final StepExecution stepExecution) throws UnexpectedJobExecutionException, JobInterruptedException {
        block25: {
            ExitStatus status = ExitStatus.FAILED;
            final ExceptionHolder fatalException = new ExceptionHolder();
            stepExecution.setStartTime(new Date(System.currentTimeMillis()));
            fatalException.setException(this.updateStatus(stepExecution, BatchStatus.STARTED));
            this.listener.beforeStep(stepExecution);
            this.stream.open(stepExecution.getExecutionContext());
            this.stream.update(stepExecution.getExecutionContext());
            this.jobRepository.saveOrUpdateExecutionContext(stepExecution);
            this.itemHandler.mark();
            status = this.stepOperations.iterate(new RepeatCallback(){

                public ExitStatus doInIteration(RepeatContext context) throws Exception {
                    StepContribution contribution = stepExecution.createStepContribution();
                    if (stepExecution.isTerminateOnly()) {
                        context.setTerminateOnly();
                    }
                    ItemOrientedStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                    ExitStatus result = ExitStatus.CONTINUABLE;
                    TransactionStatus transaction = ItemOrientedStep.this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                    try {
                        result = ItemOrientedStep.this.processChunk(stepExecution, contribution);
                        contribution.incrementCommitCount();
                        try {
                            ItemOrientedStep.this.synchronizer.lock(stepExecution);
                        }
                        catch (InterruptedException e) {
                            stepExecution.setStatus(BatchStatus.STOPPED);
                            Thread.currentThread().interrupt();
                        }
                        stepExecution.apply(contribution);
                        ItemOrientedStep.this.itemHandler.flush();
                        ItemOrientedStep.this.stream.update(stepExecution.getExecutionContext());
                        try {
                            ItemOrientedStep.this.jobRepository.saveOrUpdateExecutionContext(stepExecution);
                        }
                        catch (Exception e) {
                            fatalException.setException(e);
                            stepExecution.setStatus(BatchStatus.UNKNOWN);
                            throw new CommitFailedException("Fatal error detected during save of step execution context", e);
                        }
                        try {
                            ItemOrientedStep.this.itemHandler.mark();
                            ItemOrientedStep.this.transactionManager.commit(transaction);
                        }
                        catch (Exception e) {
                            fatalException.setException(e);
                            stepExecution.setStatus(BatchStatus.UNKNOWN);
                            throw new CommitFailedException("Fatal error detected during commit", e);
                        }
                    }
                    catch (Error e) {
                        ItemOrientedStep.this.processRollback(stepExecution, contribution, fatalException, transaction);
                        throw e;
                    }
                    catch (Exception e) {
                        ItemOrientedStep.this.processRollback(stepExecution, contribution, fatalException, transaction);
                        throw e;
                    }
                    finally {
                        ItemOrientedStep.this.synchronizer.release(stepExecution);
                    }
                    ItemOrientedStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                    return result;
                }
            });
            fatalException.setException(this.updateStatus(stepExecution, BatchStatus.COMPLETED));
            Object var6_4 = null;
            try {
                status = status.and(this.listener.afterStep(stepExecution));
            }
            catch (RuntimeException e) {
                logger.error((Object)"Unexpected error in listener after step.", (Throwable)e);
            }
            stepExecution.setExitStatus(status);
            stepExecution.setEndTime(new Date(System.currentTimeMillis()));
            try {
                this.jobRepository.saveOrUpdate(stepExecution);
            }
            catch (RuntimeException e) {
                String msg = "Fatal error detected during final save of meta data";
                logger.error((Object)msg, (Throwable)e);
                if (!fatalException.hasException()) {
                    fatalException.setException(e);
                }
                throw new UnexpectedJobExecutionException(msg, fatalException.getException());
            }
            try {
                this.stream.close(stepExecution.getExecutionContext());
            }
            catch (RuntimeException e) {
                String msg = "Fatal error detected during close of streams. The job execution completed (possibly unsuccessfully but with consistent meta-data).";
                logger.error((Object)msg, (Throwable)e);
                if (!fatalException.hasException()) {
                    fatalException.setException(e);
                }
                throw new UnexpectedJobExecutionException(msg, fatalException.getException());
            }
            if (fatalException.hasException()) {
                throw new UnexpectedJobExecutionException("Encountered an error saving batch meta data.", fatalException.getException());
            }
            break block25;
            {
                catch (CommitFailedException e) {
                    logger.error((Object)"Fatal error detected during commit.");
                    throw e;
                }
                catch (RuntimeException e) {
                    status = this.processFailure(stepExecution, fatalException, e);
                    if (e.getCause() instanceof JobInterruptedException) {
                        this.updateStatus(stepExecution, BatchStatus.STOPPED);
                        throw (JobInterruptedException)e.getCause();
                    }
                    throw e;
                }
                catch (Error e) {
                    status = this.processFailure(stepExecution, fatalException, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    status = status.and(this.listener.afterStep(stepExecution));
                }
                catch (RuntimeException e) {
                    logger.error((Object)"Unexpected error in listener after step.", (Throwable)e);
                }
                stepExecution.setExitStatus(status);
                stepExecution.setEndTime(new Date(System.currentTimeMillis()));
                try {
                    this.jobRepository.saveOrUpdate(stepExecution);
                }
                catch (RuntimeException e) {
                    String msg = "Fatal error detected during final save of meta data";
                    logger.error((Object)msg, (Throwable)e);
                    if (!fatalException.hasException()) {
                        fatalException.setException(e);
                    }
                    throw new UnexpectedJobExecutionException(msg, fatalException.getException());
                }
                try {
                    this.stream.close(stepExecution.getExecutionContext());
                }
                catch (RuntimeException e) {
                    String msg = "Fatal error detected during close of streams. The job execution completed (possibly unsuccessfully but with consistent meta-data).";
                    logger.error((Object)msg, (Throwable)e);
                    if (!fatalException.hasException()) {
                        fatalException.setException(e);
                    }
                    throw new UnexpectedJobExecutionException(msg, fatalException.getException());
                }
                if (fatalException.hasException()) {
                    throw new UnexpectedJobExecutionException("Encountered an error saving batch meta data.", fatalException.getException());
                }
                throw throwable;
            }
        }
    }

    private ExitStatus processFailure(StepExecution stepExecution, ExceptionHolder fatalException, Throwable e) {
        ExitStatus status = this.getDefaultExitStatusForFailure(e);
        if (!fatalException.hasException()) {
            try {
                status = status.and(this.listener.onErrorInStep(stepExecution, e));
            }
            catch (RuntimeException ex) {
                logger.error((Object)"Unexpected error in listener on error in step.", (Throwable)ex);
            }
            this.updateStatus(stepExecution, BatchStatus.FAILED);
        } else {
            logger.error((Object)"Fatal error detected during rollback caused by underlying exception: ", e);
        }
        return status;
    }

    private ExitStatus getDefaultExitStatusForFailure(Throwable throwable) {
        ExitStatus exitStatus;
        if (throwable instanceof JobInterruptedException) {
            exitStatus = new ExitStatus(false, JOB_INTERRUPTED, JobInterruptedException.class.getName());
        } else if (throwable instanceof NoSuchJobException) {
            exitStatus = new ExitStatus(false, "NO_SUCH_JOB");
        } else {
            String message = "";
            if (throwable != null) {
                StringWriter writer = new StringWriter();
                throwable.printStackTrace(new PrintWriter(writer));
                message = writer.toString();
            }
            exitStatus = ExitStatus.FAILED.addExitDescription(message);
        }
        return exitStatus;
    }

    protected ExitStatus processChunk(final StepExecution execution, final StepContribution contribution) {
        ExitStatus result = this.chunkOperations.iterate(new RepeatCallback(){

            public ExitStatus doInIteration(RepeatContext context) throws Exception {
                if (execution.isTerminateOnly()) {
                    context.setTerminateOnly();
                }
                ItemOrientedStep.this.interruptionPolicy.checkInterrupted(execution);
                ExitStatus exitStatus = ItemOrientedStep.this.itemHandler.handle(contribution);
                contribution.incrementItemCount();
                ItemOrientedStep.this.interruptionPolicy.checkInterrupted(execution);
                return exitStatus;
            }
        });
        return result;
    }

    private Exception updateStatus(StepExecution stepExecution, BatchStatus status) {
        stepExecution.setStatus(status);
        try {
            this.jobRepository.saveOrUpdate(stepExecution);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    private void processRollback(StepExecution stepExecution, StepContribution contribution, ExceptionHolder fatalException, TransactionStatus transaction) {
        block2: {
            stepExecution.incrementSkipCountBy(contribution.getSkipCount());
            stepExecution.rollback();
            try {
                this.itemHandler.reset();
                this.itemHandler.clear();
                this.transactionManager.rollback(transaction);
            }
            catch (Exception e) {
                if (fatalException.hasException()) break block2;
                fatalException.setException(e);
                stepExecution.setStatus(BatchStatus.UNKNOWN);
            }
        }
    }

    private class CommitFailedException
    extends RuntimeException {
        public CommitFailedException(String string, Exception e) {
            super(string, e);
        }
    }

    private static class ExceptionHolder {
        private Exception exception;

        private ExceptionHolder() {
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

