/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.step.item.AbstractStepFactoryBean;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.core.step.item.SimpleItemHandler;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;

public class RepeatOperationsStepFactoryBean
extends AbstractStepFactoryBean {
    private ItemStream[] streams = new ItemStream[0];
    private StepListener[] listeners = new StepListener[0];
    private RepeatOperations chunkOperations = new RepeatTemplate();
    private RepeatOperations stepOperations = new RepeatTemplate();

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setChunkOperations(RepeatOperations chunkOperations) {
        this.chunkOperations = chunkOperations;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        super.applyConfiguration(step);
        step.setStreams(this.streams);
        ItemReader itemReader = this.getItemReader();
        ItemWriter itemWriter = this.getItemWriter();
        if (itemReader instanceof ItemStream) {
            step.registerStream((ItemStream)itemReader);
        }
        if (itemReader instanceof StepExecutionListener) {
            step.registerStepExecutionListener((StepExecutionListener)itemReader);
        }
        if (itemWriter instanceof ItemStream) {
            step.registerStream((ItemStream)itemWriter);
        }
        if (itemWriter instanceof StepExecutionListener) {
            step.registerStepExecutionListener((StepExecutionListener)itemWriter);
        }
        BatchListenerFactoryHelper helper = new BatchListenerFactoryHelper();
        StepExecutionListener[] stepListeners = helper.getStepListeners(this.listeners);
        itemReader = helper.getItemReader(itemReader, this.listeners);
        itemWriter = helper.getItemWriter(itemWriter, this.listeners);
        RepeatOperations stepOperations = helper.addChunkListeners(this.stepOperations, this.listeners);
        this.setItemReader(itemReader);
        this.setItemWriter(itemWriter);
        step.setStepExecutionListeners(stepListeners);
        step.setItemHandler(new SimpleItemHandler(itemReader, itemWriter));
        step.setChunkOperations(this.chunkOperations);
        step.setStepOperations(stepOperations);
    }
}

