/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.step.item.AbstractStepFactoryBean;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ItemHandler;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.core.step.item.SimpleItemHandler;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class SimpleStepFactoryBean
extends AbstractStepFactoryBean {
    private int commitInterval = 1;
    private ItemStream[] streams = new ItemStream[0];
    private StepListener[] listeners = new StepListener[0];
    private TaskExecutor taskExecutor;
    private ItemHandler itemHandler;
    private RepeatTemplate stepOperations;
    private ExceptionHandler exceptionHandler;

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    protected StepListener[] getListeners() {
        return this.listeners;
    }

    protected RepeatTemplate getStepOperations() {
        return this.stepOperations;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected ItemHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void setItemHandler(ItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        super.applyConfiguration(step);
        Assert.isTrue((this.commitInterval > 0 ? 1 : 0) != 0);
        step.setStreams(this.streams);
        ItemReader itemReader = this.getItemReader();
        ItemWriter itemWriter = this.getItemWriter();
        if (itemReader instanceof ItemStream) {
            step.registerStream((ItemStream)itemReader);
        }
        if (itemReader instanceof StepExecutionListener) {
            step.registerStepExecutionListener((StepExecutionListener)itemReader);
        }
        if (itemWriter instanceof ItemStream) {
            step.registerStream((ItemStream)itemWriter);
        }
        if (itemWriter instanceof StepExecutionListener) {
            step.registerStepExecutionListener((StepExecutionListener)itemWriter);
        }
        BatchListenerFactoryHelper helper = new BatchListenerFactoryHelper();
        RepeatTemplate chunkOperations = new RepeatTemplate();
        chunkOperations.setCompletionPolicy((CompletionPolicy)new SimpleCompletionPolicy(this.commitInterval));
        helper.addChunkListeners((RepeatOperations)chunkOperations, this.listeners);
        step.setChunkOperations((RepeatOperations)chunkOperations);
        StepExecutionListener[] stepListeners = helper.getStepListeners(this.listeners);
        itemReader = helper.getItemReader(itemReader, this.listeners);
        itemWriter = helper.getItemWriter(itemWriter, this.listeners);
        this.setItemReader(itemReader);
        this.setItemWriter(itemWriter);
        step.setStepExecutionListeners(stepListeners);
        this.stepOperations = new RepeatTemplate();
        if (this.taskExecutor != null) {
            TaskExecutorRepeatTemplate repeatTemplate = new TaskExecutorRepeatTemplate();
            repeatTemplate.setTaskExecutor(this.taskExecutor);
            this.stepOperations = repeatTemplate;
        }
        step.setStepOperations((RepeatOperations)this.stepOperations);
        SimpleItemHandler itemHandler = new SimpleItemHandler(itemReader, itemWriter);
        this.setItemHandler(itemHandler);
        step.setItemHandler(itemHandler);
    }
}

