/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.tasklet;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class TaskletStep
extends AbstractStep
implements Step,
InitializingBean,
BeanNameAware {
    private static final Log logger = LogFactory.getLog((Class)TaskletStep.class);
    private Tasklet tasklet;
    private JobRepository jobRepository;
    private CompositeStepExecutionListener listener = new CompositeStepExecutionListener();

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setStepListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.listener.register(listeners[i]);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository is mandatory for TaskletStep");
        Assert.notNull((Object)this.tasklet, (String)"Tasklet is mandatory for TaskletStep");
        if (this.tasklet instanceof StepExecutionListener) {
            this.listener.register((StepExecutionListener)((Object)this.tasklet));
        }
    }

    public TaskletStep() {
    }

    public TaskletStep(Tasklet tasklet, JobRepository jobRepository) {
        this();
        this.tasklet = tasklet;
        this.jobRepository = jobRepository;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void execute(StepExecution stepExecution) throws JobInterruptedException, UnexpectedJobExecutionException {
        stepExecution.setStartTime(new Date());
        this.updateStatus(stepExecution, BatchStatus.STARTED);
        ExitStatus exitStatus = ExitStatus.FAILED;
        Exception fatalException = null;
        try {
            this.listener.beforeStep(stepExecution);
            exitStatus = this.tasklet.execute();
            try {
                exitStatus = exitStatus.and(this.listener.afterStep(stepExecution));
            }
            catch (Exception e) {
                logger.error((Object)"Encountered an error on listener close.", (Throwable)e);
            }
            try {
                this.jobRepository.saveOrUpdateExecutionContext(stepExecution);
                this.updateStatus(stepExecution, BatchStatus.COMPLETED);
            }
            catch (Exception e) {
                fatalException = e;
                this.updateStatus(stepExecution, BatchStatus.UNKNOWN);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Encountered an error running the tasklet");
            this.updateStatus(stepExecution, BatchStatus.FAILED);
            try {
                exitStatus = exitStatus.and(this.listener.onErrorInStep(stepExecution, e));
            }
            catch (Exception ex) {
                logger.error((Object)"Encountered an error on listener close.", (Throwable)ex);
            }
            if (e instanceof JobInterruptedException) {
                throw (JobInterruptedException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UnexpectedJobExecutionException(e);
        }
        finally {
            stepExecution.setExitStatus(exitStatus);
            stepExecution.setEndTime(new Date());
            try {
                this.jobRepository.saveOrUpdate(stepExecution);
            }
            catch (Exception e) {
                fatalException = e;
            }
            if (fatalException != null) {
                logger.error((Object)"Encountered an error saving batch meta data.This job is now in an unknown state and should not be restarted.", (Throwable)fatalException);
                throw new UnexpectedJobExecutionException("Encountered an error saving batch meta data.", fatalException);
            }
        }
    }

    private void updateStatus(StepExecution stepExecution, BatchStatus status) {
        stepExecution.setStatus(status);
    }
}

