/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.repeat.ExitStatus;

public class JobExecution
extends Entity {
    private JobInstance jobInstance;
    private transient Collection stepExecutions = new HashSet();
    private BatchStatus status = BatchStatus.STARTING;
    private Date startTime = null;
    private Date endTime = null;
    private ExitStatus exitStatus = ExitStatus.UNKNOWN;

    JobExecution() {
    }

    public JobExecution(JobInstance job, Long id) {
        super(id);
        this.jobInstance = job;
    }

    public JobExecution(JobInstance job) {
        this(job, null);
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public Long getJobId() {
        if (this.jobInstance != null) {
            return this.jobInstance.getId();
        }
        return null;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public void setJobInstance(JobInstance jobInstance) {
        this.jobInstance = jobInstance;
    }

    public Collection getStepExecutions() {
        return this.stepExecutions;
    }

    public StepExecution createStepExecution(Step step) {
        StepExecution stepExecution = new StepExecution(step, this, null);
        this.stepExecutions.add(stepExecution);
        return stepExecution;
    }

    public String toString() {
        return super.toString() + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", job=[" + this.jobInstance + "]";
    }

    public boolean isRunning() {
        return this.endTime == null;
    }

    public boolean isStopping() {
        return this.status == BatchStatus.STOPPING;
    }

    public void stop() {
        Iterator it = this.stepExecutions.iterator();
        while (it.hasNext()) {
            StepExecution stepExecution = (StepExecution)it.next();
            stepExecution.setTerminateOnly();
        }
        this.status = BatchStatus.STOPPING;
    }
}

