/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.util.Date;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.util.Assert;

public class StepExecution
extends Entity {
    private JobExecution jobExecution;
    private Step step;
    private BatchStatus status = BatchStatus.STARTING;
    private int itemCount = 0;
    private int commitCount = 0;
    private int rollbackCount = 0;
    private int skipCount = 0;
    private Date startTime = new Date(System.currentTimeMillis());
    private Date endTime = null;
    private ExecutionContext executionContext = new ExecutionContext();
    private ExitStatus exitStatus = ExitStatus.UNKNOWN;
    private boolean terminateOnly;

    StepExecution() {
    }

    public StepExecution(Step step, JobExecution jobExecution, Long id) {
        super(id);
        Assert.notNull((Object)step);
        this.step = step;
        this.jobExecution = jobExecution;
    }

    public StepExecution(Step step, JobExecution jobExecution) {
        this(step, jobExecution, null);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public Integer getCommitCount() {
        return new Integer(this.commitCount);
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getItemCount() {
        return new Integer(this.itemCount);
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public Integer getRollbackCount() {
        return new Integer(this.rollbackCount);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public String getStepName() {
        return this.step.getName();
    }

    public Long getJobExecutionId() {
        if (this.jobExecution != null) {
            return this.jobExecution.getId();
        }
        return null;
    }

    public boolean equals(Object obj) {
        Long jobExecutionId = this.getJobExecutionId();
        if (this.step == null && jobExecutionId == null || !(obj instanceof StepExecution) || this.getId() == null) {
            return super.equals(obj);
        }
        StepExecution other = (StepExecution)obj;
        if (this.step == null) {
            return ((Object)jobExecutionId).equals(other.getJobExecutionId());
        }
        return this.step.getName().equals(other.getStepName()) && (jobExecutionId == null || ((Object)jobExecutionId).equals(other.getJobExecutionId()));
    }

    public int hashCode() {
        Long jobExecutionId = this.getJobExecutionId();
        return super.hashCode() + 31 * (this.step.getName() != null ? this.step.getName().hashCode() : 0) + 91 * (jobExecutionId != null ? ((Object)jobExecutionId).hashCode() : 0);
    }

    public String toString() {
        return super.toString() + ", name=" + this.step.getName() + ", itemCount=" + this.itemCount + ", commitCount=" + this.commitCount + ", rollbackCount=" + this.rollbackCount;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public StepContribution createStepContribution() {
        return new StepContribution(this);
    }

    public synchronized void apply(StepContribution contribution) {
        this.itemCount += contribution.getItemCount();
        this.commitCount += contribution.getCommitCount();
        contribution.combineSkipCounts();
        this.skipCount += contribution.getSkipCount();
    }

    public synchronized void rollback() {
        ++this.rollbackCount;
    }

    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    public void setTerminateOnly() {
        this.terminateOnly = true;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void incrementSkipCountBy(int count) {
        this.skipCount += count;
    }

    public JobParameters getJobParameters() {
        if (this.jobExecution == null || this.jobExecution.getJobInstance() == null) {
            return new JobParameters();
        }
        return this.jobExecution.getJobInstance().getJobParameters();
    }
}

