/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.converter;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.util.StringUtils;

public class DefaultJobParametersConverter
implements JobParametersConverter {
    public static final String DATE_TYPE = "(date)";
    public static final String STRING_TYPE = "(string)";
    public static final String LONG_TYPE = "(long)";
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private NumberFormat numberFormat = new DecimalFormat("#");

    public JobParameters getJobParameters(Properties props) {
        if (props == null || props.isEmpty()) {
            return new JobParameters();
        }
        JobParametersBuilder propertiesBuilder = new JobParametersBuilder();
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.endsWith(DATE_TYPE)) {
                Date date;
                try {
                    date = this.dateFormat.parse(value);
                }
                catch (ParseException ex) {
                    String suffix = this.dateFormat instanceof SimpleDateFormat ? ", use " + ((SimpleDateFormat)this.dateFormat).toPattern() : "";
                    throw new IllegalArgumentException("Date format is invalid: [" + value + "]" + suffix);
                }
                propertiesBuilder.addDate(StringUtils.replace((String)key, (String)DATE_TYPE, (String)""), date);
                continue;
            }
            if (key.endsWith(LONG_TYPE)) {
                Long result;
                try {
                    result = (Long)this.numberFormat.parse(value);
                }
                catch (ParseException ex) {
                    String suffix = this.numberFormat instanceof DecimalFormat ? ", use " + ((DecimalFormat)this.numberFormat).toPattern() : "";
                    throw new IllegalArgumentException("Number format is invalid: [" + value + "], use " + suffix);
                }
                catch (ClassCastException ex) {
                    throw new IllegalArgumentException("Number format is invalid: [" + value + "], use a format with no decimal places");
                }
                propertiesBuilder.addLong(StringUtils.replace((String)key, (String)LONG_TYPE, (String)""), result);
                continue;
            }
            if (StringUtils.endsWithIgnoreCase((String)key, (String)STRING_TYPE)) {
                propertiesBuilder.addString(StringUtils.replace((String)key, (String)STRING_TYPE, (String)""), value);
                continue;
            }
            propertiesBuilder.addString(key, value.toString());
        }
        return propertiesBuilder.toJobParameters();
    }

    public Properties getProperties(JobParameters params) {
        if (params == null || params.isEmpty()) {
            return new Properties();
        }
        Map parameters = params.getParameters();
        Properties result = new Properties();
        Iterator iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Date) {
                result.setProperty(key + DATE_TYPE, this.dateFormat.format(value));
                continue;
            }
            if (value instanceof Long) {
                result.setProperty(key + LONG_TYPE, this.numberFormat.format(value));
                continue;
            }
            result.setProperty(key, "" + value);
        }
        return result;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }
}

