/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.listener.CompositeExecutionJobListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;

public class SimpleJob
extends AbstractJob {
    private JobRepository jobRepository;
    private CompositeExecutionJobListener listener = new CompositeExecutionJobListener();

    public void setJobExecutionListeners(JobExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.listener.register(listeners[i]);
        }
    }

    public void registerJobExecutionListener(JobExecutionListener listener) {
        this.listener.register(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecution execution) throws JobExecutionException {
        JobInstance jobInstance = execution.getJobInstance();
        StepExecution currentStepExecution = null;
        int startedCount = 0;
        List steps = this.getSteps();
        try {
            if (execution.getStatus() == BatchStatus.STOPPING) {
                throw new JobInterruptedException("JobExecution already stopped before being executed.");
            }
            execution.setStartTime(new Date());
            this.updateStatus(execution, BatchStatus.STARTING);
            this.listener.beforeJob(execution);
            Iterator i = steps.iterator();
            while (i.hasNext()) {
                boolean isRestart;
                Step step = (Step)i.next();
                if (!this.shouldStart(jobInstance, step)) continue;
                ++startedCount;
                this.updateStatus(execution, BatchStatus.STARTED);
                currentStepExecution = execution.createStepExecution(step);
                StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step);
                boolean bl = isRestart = this.jobRepository.getStepExecutionCount(jobInstance, step) > 0 && !lastStepExecution.getExitStatus().equals((Object)ExitStatus.FINISHED);
                if (isRestart && lastStepExecution != null) {
                    currentStepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
                } else {
                    currentStepExecution.setExecutionContext(new ExecutionContext());
                }
                step.execute(currentStepExecution);
            }
            this.updateStatus(execution, BatchStatus.COMPLETED);
            this.listener.afterJob(execution);
        }
        catch (JobInterruptedException e) {
            execution.setStatus(BatchStatus.STOPPED);
            this.listener.onInterrupt(execution);
            SimpleJob.rethrow(e);
        }
        catch (Throwable t) {
            execution.setStatus(BatchStatus.FAILED);
            this.listener.onError(execution, t);
            SimpleJob.rethrow(t);
        }
        finally {
            ExitStatus status = ExitStatus.FAILED;
            if (startedCount == 0) {
                status = steps.size() > 0 ? ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.") : ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
            } else if (currentStepExecution != null) {
                status = currentStepExecution.getExitStatus();
            }
            execution.setEndTime(new Date());
            execution.setExitStatus(status);
            this.jobRepository.saveOrUpdate(execution);
        }
    }

    private void updateStatus(JobExecution jobExecution, BatchStatus status) {
        jobExecution.setStatus(status);
        this.jobRepository.saveOrUpdate(jobExecution);
    }

    private boolean shouldStart(JobInstance jobInstance, Step step) throws JobExecutionException {
        StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step);
        BatchStatus stepStatus = lastStepExecution == null ? BatchStatus.STARTING : lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobExecutionException("Cannot restart step from UNKNOWN status.  The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete()) {
            return false;
        }
        if (this.jobRepository.getStepExecutionCount(jobInstance, step) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }

    private static void rethrow(Throwable t) throws RuntimeException {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UnexpectedJobExecutionException("Unexpected checked exception in job execution", t);
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }
}

