/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.ExportedJobLauncher;
import org.springframework.batch.core.repository.NoSuchJobException;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SimpleExportedJobLauncher
implements ExportedJobLauncher,
InitializingBean {
    private JobLauncher launcher;
    private JobLocator jobLocator;
    private Map registry = new HashMap();
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.launcher, (String)"JobLauncher must be provided.");
        Assert.notNull((Object)this.jobLocator, (String)"JobLocator must be provided.");
    }

    public void setLauncher(JobLauncher launcher) {
        this.launcher = launcher;
    }

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public void setJobParametersFactory(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public Properties getStatistics() {
        Properties result = new Properties();
        int i = 0;
        Iterator iterator = this.registry.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JobExecution execution = (JobExecution)this.registry.get(key);
            this.addStatistics(result, execution, "job" + i + ".");
            ++i;
        }
        return result;
    }

    private void addStatistics(Properties result, JobExecution execution, String prefix) {
        int i = 0;
        Iterator iterator = execution.getStepExecutions().iterator();
        while (iterator.hasNext()) {
            StepExecution stepExecution = (StepExecution)iterator.next();
            Properties statistics = stepExecution.getExecutionContext().getProperties();
            Iterator<Object> iter = statistics.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                result.setProperty(prefix + "step" + i + "." + key, statistics.getProperty(key));
            }
        }
    }

    public boolean isRunning() {
        Iterator iterator = this.registry.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JobExecution execution = (JobExecution)this.registry.get(key);
            if (!execution.isRunning()) continue;
            return true;
        }
        return false;
    }

    public String run(String name) {
        return this.run(name, null);
    }

    public String run(String name, String params) {
        JobExecution execution;
        Job job;
        try {
            job = this.jobLocator.getJob(name);
        }
        catch (NoSuchJobException e) {
            return e.getClass().getName() + ": " + e.getMessage();
        }
        JobParameters jobParameters = new JobParameters();
        if (params != null) {
            jobParameters = this.jobParametersConverter.getJobParameters(PropertiesConverter.stringToProperties((String)params));
        }
        try {
            execution = this.launcher.run(job, jobParameters);
        }
        catch (JobExecutionException e) {
            return e.getClass().getName() + ": " + e.getMessage();
        }
        this.registry.put(name + params, execution);
        return execution.toString();
    }

    public void stop() {
        Iterator iterator = this.registry.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JobExecution execution = (JobExecution)this.registry.get(key);
            execution.stop();
        }
        this.registry.clear();
    }
}

