/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ChunkListener;

public class CompositeChunkListener
implements ChunkListener {
    private List listeners = new ArrayList();

    public void setListeners(ChunkListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(ChunkListener chunkListener) {
        if (!this.listeners.contains(chunkListener)) {
            this.listeners.add(chunkListener);
        }
    }

    public void afterChunk() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChunkListener listener = (ChunkListener)iterator.next();
            listener.afterChunk();
        }
    }

    public void beforeChunk() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChunkListener listener = (ChunkListener)iterator.next();
            listener.beforeChunk();
        }
    }
}

