/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ItemWriteListener;

public class CompositeItemWriteListener
implements ItemWriteListener {
    private List listeners = new ArrayList();

    public void setListeners(ItemWriteListener[] itemWriteListeners) {
        this.listeners = Arrays.asList(itemWriteListeners);
    }

    public void register(ItemWriteListener itemReaderListener) {
        if (!this.listeners.contains(itemReaderListener)) {
            this.listeners.add(itemReaderListener);
        }
    }

    public void afterWrite(Object item) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemWriteListener listener = (ItemWriteListener)iterator.next();
            listener.afterWrite(item);
        }
    }

    public void beforeWrite(Object item) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemWriteListener listener = (ItemWriteListener)iterator.next();
            listener.beforeWrite(item);
        }
    }

    public void onWriteError(Exception ex, Object item) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemWriteListener listener = (ItemWriteListener)iterator.next();
            listener.onWriteError(ex, item);
        }
    }
}

