/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.repeat.ExitStatus;

public class CompositeStepExecutionListener
implements StepExecutionListener {
    private List listeners = new ArrayList();

    public void setListeners(StepExecutionListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(StepExecutionListener stepExecutionListener) {
        if (!this.listeners.contains(stepExecutionListener)) {
            this.listeners.add(stepExecutionListener);
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            StepExecutionListener listener = (StepExecutionListener)iterator.next();
            ExitStatus close = listener.afterStep(stepExecution);
            status = status != null ? status.and(close) : close;
        }
        return status;
    }

    public void beforeStep(StepExecution stepExecution) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            StepExecutionListener listener = (StepExecutionListener)iterator.next();
            listener.beforeStep(stepExecution);
        }
    }

    public ExitStatus onErrorInStep(StepExecution stepExecution, Throwable e) {
        ExitStatus status = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            StepExecutionListener listener = (StepExecutionListener)iterator.next();
            ExitStatus close = listener.onErrorInStep(stepExecution, e);
            status = status != null ? status.and(close) : close;
        }
        return status;
    }
}

