/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class JdbcJobInstanceDao
extends AbstractJdbcBatchMetadataDao
implements JobInstanceDao,
InitializingBean {
    private static final String CREATE_JOB_INSTANCE = "INSERT into %PREFIX%JOB_INSTANCE(JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, VERSION) values (?, ?, ?, ?)";
    private static final String CREATE_JOB_PARAMETERS = "INSERT into %PREFIX%JOB_PARAMS(JOB_INSTANCE_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String FIND_JOBS = "SELECT JOB_INSTANCE_ID from %PREFIX%JOB_INSTANCE where JOB_NAME = ? and JOB_KEY = ?";
    private DataFieldMaxValueIncrementer jobIncrementer;

    public JobInstance createJobInstance(Job job, JobParameters jobParameters) {
        Assert.notNull((Object)job, (String)"Job must not be null.");
        Assert.hasLength((String)job.getName(), (String)"Job must have a name");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        Assert.state((this.getJobInstance(job, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        Long jobId = new Long(this.jobIncrementer.nextLongValue());
        JobInstance jobInstance = new JobInstance(jobId, jobParameters, job);
        jobInstance.incrementVersion();
        Object[] parameters = new Object[]{jobId, job.getName(), this.createJobKey(jobParameters), jobInstance.getVersion()};
        this.getJdbcTemplate().update(this.getQuery(CREATE_JOB_INSTANCE), parameters, new int[]{4, 12, 12, 4});
        this.insertJobParameters(jobId, jobParameters);
        return jobInstance;
    }

    private String createJobKey(JobParameters jobParameters) {
        Map props = jobParameters.getParameters();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            stringBuffer.append(entry.toString() + ";");
        }
        return stringBuffer.toString();
    }

    private void insertJobParameters(Long jobId, JobParameters jobParameters) {
        Map.Entry entry;
        Iterator it;
        Map parameters = jobParameters.getStringParameters();
        if (!parameters.isEmpty()) {
            it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.insertParameter(jobId, ParameterType.STRING, entry.getKey().toString(), entry.getValue());
            }
        }
        if (!(parameters = jobParameters.getLongParameters()).isEmpty()) {
            it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.insertParameter(jobId, ParameterType.LONG, entry.getKey().toString(), entry.getValue());
            }
        }
        if (!(parameters = jobParameters.getDoubleParameters()).isEmpty()) {
            it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.insertParameter(jobId, ParameterType.DOUBLE, entry.getKey().toString(), entry.getValue());
            }
        }
        if (!(parameters = jobParameters.getDateParameters()).isEmpty()) {
            it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.insertParameter(jobId, ParameterType.DATE, entry.getKey().toString(), entry.getValue());
            }
        }
    }

    private void insertParameter(Long jobId, ParameterType type, String key, Object value) {
        Object[] args = new Object[]{};
        int[] argTypes = new int[]{-5, 12, 12, 12, 93, -5, 8};
        if (type == ParameterType.STRING) {
            args = new Object[]{jobId, key, type, value, new Timestamp(0L), new Long(0L), new Double(0.0)};
        } else if (type == ParameterType.LONG) {
            args = new Object[]{jobId, key, type, "", new Timestamp(0L), value, new Double(0.0)};
        } else if (type == ParameterType.DOUBLE) {
            args = new Object[]{jobId, key, type, "", new Timestamp(0L), new Long(0L), value};
        } else if (type == ParameterType.DATE) {
            args = new Object[]{jobId, key, type, "", value, new Long(0L), new Double(0.0)};
        }
        this.getJdbcTemplate().update(this.getQuery(CREATE_JOB_PARAMETERS), args, argTypes);
    }

    public JobInstance getJobInstance(final Job job, final JobParameters jobParameters) {
        Assert.notNull((Object)job, (String)"Job must not be null.");
        Assert.hasLength((String)job.getName(), (String)"Job must have a name");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        Object[] parameters = new Object[]{job.getName(), this.createJobKey(jobParameters)};
        RowMapper rowMapper = new RowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                JobInstance jobInstance = new JobInstance(new Long(rs.getLong(1)), jobParameters, job);
                return jobInstance;
            }
        };
        List instances = this.getJdbcTemplate().query(this.getQuery(FIND_JOBS), parameters, rowMapper);
        if (instances.isEmpty()) {
            return null;
        }
        Assert.state((instances.size() == 1 ? 1 : 0) != 0);
        return (JobInstance)instances.get(0);
    }

    public void setJobIncrementer(DataFieldMaxValueIncrementer jobIncrementer) {
        this.jobIncrementer = jobIncrementer;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.jobIncrementer);
    }

    private static class ParameterType {
        private final String type;
        public static final ParameterType STRING = new ParameterType("STRING");
        public static final ParameterType DATE = new ParameterType("DATE");
        public static final ParameterType LONG = new ParameterType("LONG");
        public static final ParameterType DOUBLE = new ParameterType("DOUBLE");
        private static final ParameterType[] VALUES = new ParameterType[]{STRING, DATE, LONG, DOUBLE};

        private ParameterType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static ParameterType getType(String typeAsString) {
            for (int i = 0; i < VALUES.length; ++i) {
                if (!VALUES[i].toString().equals(typeAsString)) continue;
                return VALUES[i];
            }
            return null;
        }
    }
}

