/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;

public class JdbcStepExecutionDao
extends AbstractJdbcBatchMetadataDao
implements StepExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)JdbcStepExecutionDao.class);
    private static final String FIND_STEP_EXECUTION_CONTEXT = "SELECT TYPE_CD, KEY_NAME, STRING_VAL, DOUBLE_VAL, LONG_VAL, OBJECT_VAL from %PREFIX%STEP_EXECUTION_CONTEXT where STEP_EXECUTION_ID = ?";
    private static final String INSERT_STEP_EXECUTION_CONTEXT = "INSERT into %PREFIX%STEP_EXECUTION_CONTEXT(STEP_EXECUTION_ID, TYPE_CD, KEY_NAME, STRING_VAL, DOUBLE_VAL, LONG_VAL, OBJECT_VAL) values(?,?,?,?,?,?,?)";
    private static final String SAVE_STEP_EXECUTION = "INSERT into %PREFIX%STEP_EXECUTION(STEP_EXECUTION_ID, VERSION, STEP_NAME, JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, COMMIT_COUNT, ITEM_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_STEP_EXECUTION_CONTEXT = "UPDATE %PREFIX%STEP_EXECUTION_CONTEXT set TYPE_CD = ?, STRING_VAL = ?, DOUBLE_VAL = ?, LONG_VAL = ?, OBJECT_VAL = ? where STEP_EXECUTION_ID = ? and KEY_NAME = ?";
    private static final String UPDATE_STEP_EXECUTION = "UPDATE %PREFIX%STEP_EXECUTION set START_TIME = ?, END_TIME = ?, STATUS = ?, COMMIT_COUNT = ?, ITEM_COUNT = ?, CONTINUABLE = ? , EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ? where STEP_EXECUTION_ID = ? and VERSION = ?";
    private static final String GET_STEP_EXECUTION = "SELECT STEP_EXECUTION_ID, STEP_NAME, START_TIME, END_TIME, STATUS, COMMIT_COUNT, ITEM_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE from %PREFIX%STEP_EXECUTION where STEP_NAME = ? and JOB_EXECUTION_ID = ?";
    private static final String CURRENT_VERSION_STEP_EXECUTION = "SELECT VERSION FROM %PREFIX%STEP_EXECUTION WHERE STEP_EXECUTION_ID=?";
    private static final int EXIT_MESSAGE_LENGTH = 250;
    private LobHandler lobHandler = new DefaultLobHandler();
    private DataFieldMaxValueIncrementer stepExecutionIncrementer;

    public ExecutionContext findExecutionContext(StepExecution stepExecution) {
        final Long executionId = stepExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        final ExecutionContext executionContext = new ExecutionContext();
        RowCallbackHandler callback = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String typeCd = rs.getString("TYPE_CD");
                AttributeType type = AttributeType.getType(typeCd);
                String key = rs.getString("KEY_NAME");
                if (type == AttributeType.STRING) {
                    executionContext.putString(key, rs.getString("STRING_VAL"));
                } else if (type == AttributeType.LONG) {
                    executionContext.putLong(key, rs.getLong("LONG_VAL"));
                } else if (type == AttributeType.DOUBLE) {
                    executionContext.putDouble(key, rs.getDouble("DOUBLE_VAL"));
                } else if (type == AttributeType.OBJECT) {
                    executionContext.put(key, SerializationUtils.deserialize((InputStream)rs.getBinaryStream("OBJECT_VAL")));
                } else {
                    throw new UnexpectedJobExecutionException("Invalid type found: [" + typeCd + "] for execution id: [" + executionId + "]");
                }
            }
        };
        this.getJdbcTemplate().query(this.getQuery(FIND_STEP_EXECUTION_CONTEXT), new Object[]{executionId}, callback);
        return executionContext;
    }

    private void insertExecutionAttribute(final Long executionId, final String key, final Object value, final AttributeType type) {
        AbstractLobCreatingPreparedStatementCallback callback = new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                ps.setLong(1, executionId);
                ps.setString(3, key);
                if (type == AttributeType.STRING) {
                    ps.setString(2, AttributeType.STRING.toString());
                    ps.setString(4, value.toString());
                    ps.setDouble(5, 0.0);
                    ps.setLong(6, 0L);
                    lobCreator.setBlobAsBytes(ps, 7, null);
                } else if (type == AttributeType.DOUBLE) {
                    ps.setString(2, AttributeType.DOUBLE.toString());
                    ps.setString(4, null);
                    ps.setDouble(5, (Double)value);
                    ps.setLong(6, 0L);
                    lobCreator.setBlobAsBytes(ps, 7, null);
                } else if (type == AttributeType.LONG) {
                    ps.setString(2, AttributeType.LONG.toString());
                    ps.setString(4, null);
                    ps.setDouble(5, 0.0);
                    ps.setLong(6, (Long)value);
                    lobCreator.setBlobAsBytes(ps, 7, null);
                } else {
                    ps.setString(2, AttributeType.OBJECT.toString());
                    ps.setString(4, null);
                    ps.setDouble(5, 0.0);
                    ps.setLong(6, 0L);
                    lobCreator.setBlobAsBytes(ps, 7, SerializationUtils.serialize((Serializable)((Serializable)value)));
                }
            }
        };
        this.getJdbcTemplate().execute(this.getQuery(INSERT_STEP_EXECUTION_CONTEXT), (PreparedStatementCallback)callback);
    }

    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isNull((Object)stepExecution.getId(), (String)"to-be-saved (not updated) StepExecution can't already have an id assigned");
        Assert.isNull((Object)stepExecution.getVersion(), (String)"to-be-saved (not updated) StepExecution can't already have a version assigned");
        this.validateStepExecution(stepExecution);
        stepExecution.setId(new Long(this.stepExecutionIncrementer.nextLongValue()));
        stepExecution.incrementVersion();
        Object[] parameters = new Object[]{stepExecution.getId(), stepExecution.getVersion(), stepExecution.getStepName(), stepExecution.getJobExecutionId(), stepExecution.getStartTime(), stepExecution.getEndTime(), stepExecution.getStatus().toString(), stepExecution.getCommitCount(), stepExecution.getItemCount(), stepExecution.getExitStatus().isContinuable() ? "Y" : "N", stepExecution.getExitStatus().getExitCode(), stepExecution.getExitStatus().getExitDescription()};
        this.getJdbcTemplate().update(this.getQuery(SAVE_STEP_EXECUTION), parameters, new int[]{4, 4, 12, 4, 93, 93, 12, 4, 4, 1, 12, 12});
    }

    private void validateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution);
        Assert.notNull((Object)stepExecution.getStepName(), (String)"StepExecution step name cannot be null.");
        Assert.notNull((Object)stepExecution.getStartTime(), (String)"StepExecution start time cannot be null.");
        Assert.notNull((Object)stepExecution.getStatus(), (String)"StepExecution status cannot be null.");
    }

    public void saveOrUpdateExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        Iterator it = executionContext.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.updateExecutionAttribute(executionId, key, value, AttributeType.STRING);
                continue;
            }
            if (value instanceof Double) {
                this.updateExecutionAttribute(executionId, key, value, AttributeType.DOUBLE);
                continue;
            }
            if (value instanceof Long) {
                this.updateExecutionAttribute(executionId, key, value, AttributeType.LONG);
                continue;
            }
            this.updateExecutionAttribute(executionId, key, value, AttributeType.OBJECT);
        }
    }

    private void updateExecutionAttribute(final Long executionId, final String key, final Object value, final AttributeType type) {
        AbstractLobCreatingPreparedStatementCallback callback = new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                ps.setLong(6, executionId);
                ps.setString(7, key);
                if (type == AttributeType.STRING) {
                    ps.setString(1, AttributeType.STRING.toString());
                    ps.setString(2, value.toString());
                    ps.setDouble(3, 0.0);
                    ps.setLong(4, 0L);
                    lobCreator.setBlobAsBytes(ps, 5, null);
                } else if (type == AttributeType.DOUBLE) {
                    ps.setString(1, AttributeType.DOUBLE.toString());
                    ps.setString(2, null);
                    ps.setDouble(3, (Double)value);
                    ps.setLong(4, 0L);
                    lobCreator.setBlobAsBytes(ps, 5, null);
                } else if (type == AttributeType.LONG) {
                    ps.setString(1, AttributeType.LONG.toString());
                    ps.setString(2, null);
                    ps.setDouble(3, 0.0);
                    ps.setLong(4, (Long)value);
                    lobCreator.setBlobAsBytes(ps, 5, null);
                } else {
                    ps.setString(1, AttributeType.OBJECT.toString());
                    ps.setString(2, null);
                    ps.setDouble(3, 0.0);
                    ps.setLong(4, 0L);
                    lobCreator.setBlobAsBytes(ps, 5, SerializationUtils.serialize((Serializable)((Serializable)value)));
                }
            }
        };
        Integer affectedRows = (Integer)this.getJdbcTemplate().execute(this.getQuery(UPDATE_STEP_EXECUTION_CONTEXT), (PreparedStatementCallback)callback);
        if (affectedRows < 1) {
            this.insertExecutionAttribute(executionId, key, value, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStepExecution(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull((Object)stepExecution.getId(), (String)"StepExecution Id cannot be null. StepExecution must saved before it can be updated.");
        String exitDescription = stepExecution.getExitStatus().getExitDescription();
        if (exitDescription != null && exitDescription.length() > 250) {
            exitDescription = exitDescription.substring(0, 250);
            logger.debug((Object)("Truncating long message before update of StepExecution: " + stepExecution));
        }
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            Integer version = new Integer(stepExecution.getVersion() + 1);
            Object[] parameters = new Object[]{stepExecution.getStartTime(), stepExecution.getEndTime(), stepExecution.getStatus().toString(), stepExecution.getCommitCount(), stepExecution.getItemCount(), stepExecution.getExitStatus().isContinuable() ? "Y" : "N", stepExecution.getExitStatus().getExitCode(), exitDescription, version, stepExecution.getId(), stepExecution.getVersion()};
            int count = this.getJdbcTemplate().update(this.getQuery(UPDATE_STEP_EXECUTION), parameters, new int[]{93, 93, 12, 4, 4, 1, 12, 12, 4, 4, 4});
            if (count == 0) {
                int curentVersion = this.getJdbcTemplate().queryForInt(this.getQuery(CURRENT_VERSION_STEP_EXECUTION), new Object[]{stepExecution.getId()});
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + curentVersion);
            }
            stepExecution.incrementVersion();
        }
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setStepExecutionIncrementer(DataFieldMaxValueIncrementer stepExecutionIncrementer) {
        this.stepExecutionIncrementer = stepExecutionIncrementer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.stepExecutionIncrementer, (String)"StepExecutionIncrementer cannot be null.");
    }

    public StepExecution getStepExecution(JobExecution jobExecution, Step step) {
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_STEP_EXECUTION), new Object[]{step.getName(), jobExecution.getId()}, (RowMapper)new StepExecutionRowMapper(jobExecution, step));
        Assert.state((executions.size() <= 1 ? 1 : 0) != 0, (String)"There can be at most one step execution with given name for single job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return (StepExecution)executions.get(0);
    }

    public static class AttributeType {
        private final String type;
        public static final AttributeType STRING = new AttributeType("STRING");
        public static final AttributeType LONG = new AttributeType("LONG");
        public static final AttributeType OBJECT = new AttributeType("OBJECT");
        public static final AttributeType DOUBLE = new AttributeType("DOUBLE");
        private static final AttributeType[] VALUES = new AttributeType[]{STRING, OBJECT, LONG, DOUBLE};

        private AttributeType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static AttributeType getType(String typeAsString) {
            for (int i = 0; i < VALUES.length; ++i) {
                if (!VALUES[i].toString().equals(typeAsString)) continue;
                return VALUES[i];
            }
            return null;
        }
    }

    private class StepExecutionRowMapper
    implements RowMapper {
        private final JobExecution jobExecution;
        private final Step step;

        public StepExecutionRowMapper(JobExecution jobExecution, Step step) {
            this.jobExecution = jobExecution;
            this.step = step;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            StepExecution stepExecution = new StepExecution(this.step, this.jobExecution, new Long(rs.getLong(1)));
            stepExecution.setStartTime(rs.getTimestamp(3));
            stepExecution.setEndTime(rs.getTimestamp(4));
            stepExecution.setStatus(BatchStatus.getStatus(rs.getString(5)));
            stepExecution.setCommitCount(rs.getInt(6));
            stepExecution.setItemCount(rs.getInt(7));
            stepExecution.setExitStatus(new ExitStatus("Y".equals(rs.getString(8)), rs.getString(9), rs.getString(10)));
            stepExecution.setExecutionContext(JdbcStepExecutionDao.this.findExecutionContext(stepExecution));
            return stepExecution;
        }
    }
}

