/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.listener.CompositeSkipListener;
import org.springframework.batch.core.step.item.SimpleItemHandler;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.core.step.skip.NeverSkipItemSkipPolicy;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ItemSkipPolicyItemHandler
extends SimpleItemHandler {
    private static final String TO_BE_REMOVED = ItemSkipPolicyItemHandler.class.getName() + ".TO_BE_REMOVED";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ItemSkipPolicy itemSkipPolicy = new NeverSkipItemSkipPolicy();
    private int skipCacheCapacity = 1024;
    private Map skippedExceptions = new HashMap();
    private ItemKeyGenerator defaultItemKeyGenerator;
    private ItemKeyGenerator itemKeyGenerator = this.defaultItemKeyGenerator = new ItemKeyGenerator(){

        public Object getKey(Object item) {
            return item;
        }
    };
    private CompositeSkipListener listener = new CompositeSkipListener();

    public void setSkipListeners(SkipListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerSkipListener(listeners[i]);
        }
    }

    public void registerSkipListener(SkipListener listener) {
        this.listener.register(listener);
    }

    public void setItemKeyGenerator(ItemKeyGenerator itemKeyGenerator) {
        if (itemKeyGenerator == null) {
            itemKeyGenerator = this.defaultItemKeyGenerator;
        }
        this.itemKeyGenerator = itemKeyGenerator;
    }

    public ItemSkipPolicyItemHandler(ItemReader itemReader, ItemWriter itemWriter) {
        super(itemReader, itemWriter);
    }

    public void setItemSkipPolicy(ItemSkipPolicy itemSkipPolicy) {
        this.itemSkipPolicy = itemSkipPolicy;
    }

    public void setSkipCacheCapacity(int skipCacheCapacity) {
        this.skipCacheCapacity = skipCacheCapacity;
    }

    protected Object read(StepContribution contribution) throws Exception {
        while (true) {
            try {
                Object item = this.doRead();
                Object key = this.itemKeyGenerator.getKey(item);
                Throwable throwable = this.getSkippedException(key);
                while (item != null && throwable != null) {
                    this.logger.debug((Object)("Skipping item on input, previously failed on output; key=[" + key + "]"));
                    this.scheduleForRemoval(key);
                    if (this.listener != null) {
                        this.listener.onSkipInWrite(item, throwable);
                    }
                    item = this.doRead();
                    key = this.itemKeyGenerator.getKey(item);
                    throwable = this.getSkippedException(key);
                }
                return item;
            }
            catch (Exception e) {
                try {
                    if (this.itemSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                        contribution.incrementReadSkipCount();
                        if (this.listener != null) {
                            this.listener.onSkipInRead(e);
                        }
                        this.logger.debug((Object)"Skipping failed input", (Throwable)e);
                        continue;
                    }
                    throw e;
                }
                catch (SkipLimitExceededException ex) {
                    contribution.combineSkipCounts();
                    throw ex;
                }
            }
            break;
        }
    }

    protected void write(Object item, StepContribution contribution) throws Exception {
        this.doWriteWithSkip(item, contribution);
    }

    protected final void doWriteWithSkip(Object item, StepContribution contribution) throws Exception {
        Object key = this.itemKeyGenerator.getKey(item);
        try {
            this.doWrite(item);
        }
        catch (Exception e) {
            if (this.itemSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                contribution.incrementSkipCount();
                this.addSkippedException(key, e);
                this.logger.debug((Object)("Added item to skip list; key=" + key));
            }
            throw e;
        }
    }

    public void mark() throws MarkFailedException {
        super.mark();
        this.clearSkippedExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSkippedException(Object key, Throwable e) {
        Map map = this.skippedExceptions;
        synchronized (map) {
            if (this.skippedExceptions.size() >= this.skipCacheCapacity) {
                throw new UnexpectedJobExecutionException("The cache of failed items to skipped unexpectedly reached its capacity (" + this.skipCacheCapacity + "). " + "This often indicates a problem with the key generation strategy, and/or a mistake in the implementation of hashCode and equals in the items being processed.");
            }
            this.skippedExceptions.put(key, e);
        }
    }

    private void scheduleForRemoval(Object key) {
        if (!TransactionSynchronizationManager.hasResource((Object)TO_BE_REMOVED)) {
            TransactionSynchronizationManager.bindResource((Object)TO_BE_REMOVED, new HashSet());
        }
        ((Set)TransactionSynchronizationManager.getResource((Object)TO_BE_REMOVED)).add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSkippedExceptions() {
        if (!TransactionSynchronizationManager.hasResource((Object)TO_BE_REMOVED)) {
            return;
        }
        Map map = this.skippedExceptions;
        synchronized (map) {
            Iterator iterator = ((Set)TransactionSynchronizationManager.getResource((Object)TO_BE_REMOVED)).iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.skippedExceptions.remove(key);
            }
            TransactionSynchronizationManager.unbindResource((Object)TO_BE_REMOVED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getSkippedException(Object key) {
        Map map = this.skippedExceptions;
        synchronized (map) {
            return (Throwable)this.skippedExceptions.get(key);
        }
    }
}

