/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.ItemHandler;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.batch.item.ResetFailedException;
import org.springframework.batch.repeat.ExitStatus;

public class SimpleItemHandler
implements ItemHandler {
    private ItemReader itemReader;
    private ItemWriter itemWriter;

    public SimpleItemHandler(ItemReader itemReader, ItemWriter itemWriter) {
        this.itemReader = itemReader;
        this.itemWriter = itemWriter;
    }

    public ExitStatus handle(StepContribution contribution) throws Exception {
        Object item = this.read(contribution);
        if (item == null) {
            return ExitStatus.FINISHED;
        }
        this.write(item, contribution);
        return ExitStatus.CONTINUABLE;
    }

    protected Object read(StepContribution contribution) throws Exception {
        return this.doRead();
    }

    protected final Object doRead() throws Exception {
        return this.itemReader.read();
    }

    protected void write(Object item, StepContribution contribution) throws Exception {
        contribution.incrementItemCount();
        this.doWrite(item);
    }

    protected final void doWrite(Object item) throws Exception {
        this.itemWriter.write(item);
    }

    public void mark() throws MarkFailedException {
        this.itemReader.mark();
    }

    public void reset() throws ResetFailedException {
        this.itemReader.reset();
    }

    public void clear() throws ClearFailedException {
        this.itemWriter.clear();
    }

    public void flush() throws FlushFailedException {
        this.itemWriter.flush();
    }
}

