/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.core.step.item.ItemSkipPolicyItemHandler;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NeverSkipItemSkipPolicy;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.exception.SimpleLimitExceptionHandler;

public class SkipLimitStepFactoryBean
extends SimpleStepFactoryBean {
    private int skipLimit = 0;
    private Class[] skippableExceptionClasses = new Class[]{Exception.class};
    private Class[] fatalExceptionClasses = new Class[]{Error.class};
    private ItemKeyGenerator itemKeyGenerator;
    private int skipCacheCapacity = 1024;
    private ItemSkipPolicy itemSkipPolicy;

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkippableExceptionClasses(Class[] exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setFatalExceptionClasses(Class[] fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }

    protected Class[] getFatalExceptionClasses() {
        return this.fatalExceptionClasses;
    }

    public void setItemKeyGenerator(ItemKeyGenerator itemKeyGenerator) {
        this.itemKeyGenerator = itemKeyGenerator;
    }

    protected ItemKeyGenerator getItemKeyGenerator() {
        return this.itemKeyGenerator;
    }

    protected ItemSkipPolicy getItemSkipPolicy() {
        return this.itemSkipPolicy;
    }

    public void setSkipCacheCapacity(int skipCacheCapacity) {
        this.skipCacheCapacity = skipCacheCapacity;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        super.applyConfiguration(step);
        ItemSkipPolicyItemHandler itemHandler = new ItemSkipPolicyItemHandler(this.getItemReader(), this.getItemWriter());
        if (this.skipLimit > 0) {
            this.addFatalExceptionIfMissing(SkipLimitExceededException.class);
            List<Class> fatalExceptionList = Arrays.asList(this.fatalExceptionClasses);
            LimitCheckingItemSkipPolicy limitCheckingSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, Arrays.asList(this.skippableExceptionClasses), fatalExceptionList);
            itemHandler.setItemSkipPolicy(limitCheckingSkipPolicy);
            this.itemSkipPolicy = limitCheckingSkipPolicy;
            SimpleLimitExceptionHandler exceptionHandler = new SimpleLimitExceptionHandler(this.skipLimit);
            exceptionHandler.setExceptionClasses(this.skippableExceptionClasses);
            exceptionHandler.setFatalExceptionClasses(this.fatalExceptionClasses);
            this.getStepOperations().setExceptionHandler((ExceptionHandler)exceptionHandler);
            this.setExceptionHandler((ExceptionHandler)exceptionHandler);
            itemHandler.setItemKeyGenerator(this.itemKeyGenerator);
            itemHandler.setSkipCacheCapacity(this.skipCacheCapacity);
            BatchListenerFactoryHelper helper = new BatchListenerFactoryHelper();
            itemHandler.setSkipListeners(helper.getSkipListeners(this.getListeners()));
        } else {
            itemHandler.setItemSkipPolicy(new NeverSkipItemSkipPolicy());
        }
        step.setItemHandler(itemHandler);
    }

    public void addFatalExceptionIfMissing(Class cls) {
        ArrayList<Class> fatalExceptionList = new ArrayList<Class>(Arrays.asList(this.fatalExceptionClasses));
        if (!fatalExceptionList.contains(cls)) {
            fatalExceptionList.add(cls);
        }
        this.fatalExceptionClasses = fatalExceptionList.toArray(new Class[0]);
    }
}

