/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.core.step.item.ItemSkipPolicyItemHandler;
import org.springframework.batch.core.step.item.SimpleRetryExceptionHandler;
import org.springframework.batch.core.step.item.SkipLimitStepFactoryBean;
import org.springframework.batch.item.AbstractItemWriter;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemRecoverer;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.callback.ItemWriterRetryCallback;
import org.springframework.batch.retry.policy.ItemWriterRetryPolicy;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.batch.retry.support.RetryTemplate;

public class StatefulRetryStepFactoryBean
extends SkipLimitStepFactoryBean {
    private ItemRecoverer itemRecoverer;
    private int retryLimit;
    private Class[] retryableExceptionClasses;
    private BackOffPolicy backOffPolicy;
    private RetryListener[] retryListeners;

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setRetryableExceptionClasses(Class[] retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryListeners(RetryListener[] retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setItemRecoverer(ItemRecoverer itemRecoverer) {
        this.itemRecoverer = itemRecoverer;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        super.applyConfiguration(step);
        if (this.retryLimit > 0) {
            this.addFatalExceptionIfMissing(RetryException.class);
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(this.retryLimit);
            if (this.retryableExceptionClasses != null) {
                retryPolicy.setRetryableExceptionClasses(this.retryableExceptionClasses);
                retryPolicy.setFatalExceptionClasses(this.getFatalExceptionClasses());
            }
            this.getStepOperations().setExceptionHandler((ExceptionHandler)new SimpleRetryExceptionHandler((RetryPolicy)retryPolicy, this.getExceptionHandler(), this.getFatalExceptionClasses()));
            ItemWriterRetryPolicy itemWriterRetryPolicy = new ItemWriterRetryPolicy((RetryPolicy)retryPolicy);
            RetryTemplate retryTemplate = new RetryTemplate();
            if (this.retryListeners != null) {
                retryTemplate.setListeners(this.retryListeners);
            }
            retryTemplate.setRetryPolicy((RetryPolicy)itemWriterRetryPolicy);
            if (this.backOffPolicy != null) {
                retryTemplate.setBackOffPolicy(this.backOffPolicy);
            }
            StatefulRetryItemHandler itemHandler = new StatefulRetryItemHandler(this.getItemReader(), this.getItemWriter(), (RetryOperations)retryTemplate, this.getItemKeyGenerator(), this.itemRecoverer);
            itemHandler.setItemSkipPolicy(this.getItemSkipPolicy());
            step.setItemHandler(itemHandler);
        }
    }

    private static class StatefulRetryItemHandler
    extends ItemSkipPolicyItemHandler {
        private final RetryOperations retryOperations;
        private final ItemKeyGenerator itemKeyGenerator;
        private final ItemRecoverer itemRecoverer;

        public StatefulRetryItemHandler(ItemReader itemReader, ItemWriter itemWriter, RetryOperations retryTemplate, ItemKeyGenerator itemKeyGenerator, ItemRecoverer itemRecoverer) {
            super(itemReader, itemWriter);
            this.retryOperations = retryTemplate;
            this.itemKeyGenerator = itemKeyGenerator;
            this.itemRecoverer = itemRecoverer;
        }

        protected void write(Object item, StepContribution contribution) throws Exception {
            RetryableItemWriter writer = new RetryableItemWriter(contribution);
            ItemWriterRetryCallback retryCallback = new ItemWriterRetryCallback(item, (ItemWriter)writer);
            retryCallback.setKeyGenerator(this.itemKeyGenerator);
            retryCallback.setRecoverer(this.itemRecoverer);
            this.retryOperations.execute((RetryCallback)retryCallback);
        }

        private class RetryableItemWriter
        extends AbstractItemWriter {
            private StepContribution contribution;

            public RetryableItemWriter(StepContribution contribution) {
                this.contribution = contribution;
            }

            public void write(Object item) throws Exception {
                StatefulRetryItemHandler.this.doWriteWithSkip(item, this.contribution);
            }
        }
    }
}

