/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ClassPathXmlApplicationContextJobFactory
implements JobFactory {
    private final String beanName;
    private final String path;
    private final ApplicationContext parent;

    public ClassPathXmlApplicationContextJobFactory(String beanName, String path, ApplicationContext parent) {
        this.beanName = beanName;
        this.path = path;
        this.parent = parent;
    }

    public Job createJob() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{this.path}, false, this.parent);
        context.setDisplayName("Job ApplicationContext " + this.beanName);
        context.refresh();
        Job job = (Job)context.getBean(this.beanName, Job.class);
        return new ContextClosingJob(job, (ConfigurableApplicationContext)context);
    }

    public String getJobName() {
        return this.beanName;
    }

    private static class ContextClosingJob
    implements Job {
        private Job delegate;
        private ConfigurableApplicationContext context;

        public ContextClosingJob(Job delegate, ConfigurableApplicationContext context) {
            this.delegate = delegate;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecution execution) throws JobExecutionException {
            try {
                this.delegate.execute(execution);
            }
            finally {
                this.context.close();
            }
        }

        public String getName() {
            return this.delegate.getName();
        }

        public List getSteps() {
            return this.delegate.getSteps();
        }

        public boolean isRestartable() {
            return this.delegate.isRestartable();
        }
    }
}

