/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.JobParametersConverter;

public class ScheduledJobParametersFactory
implements JobParametersConverter {
    public static final String SCHEDULE_DATE_KEY = "schedule.date";
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");

    public JobParameters getJobParameters(Properties props) {
        if (props == null || props.isEmpty()) {
            return new JobParameters();
        }
        JobParametersBuilder propertiesBuilder = new JobParametersBuilder();
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            if (entry.getKey().equals(SCHEDULE_DATE_KEY)) {
                Date scheduleDate;
                try {
                    scheduleDate = this.dateFormat.parse(entry.getValue().toString());
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException("Date format is invalid: [" + entry.getValue() + "]");
                }
                propertiesBuilder.addDate(entry.getKey().toString(), scheduleDate);
                continue;
            }
            propertiesBuilder.addString(entry.getKey().toString(), entry.getValue().toString());
        }
        return propertiesBuilder.toJobParameters();
    }

    public Properties getProperties(JobParameters params) {
        if (params == null || params.isEmpty()) {
            return new Properties();
        }
        Map parameters = params.getParameters();
        Properties result = new Properties();
        Iterator iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (key.equals(SCHEDULE_DATE_KEY)) {
                result.setProperty(key, this.dateFormat.format(entry.getValue()));
                continue;
            }
            result.setProperty(key, "" + entry.getValue());
        }
        return result;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }
}

