/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;

class JdbcExecutionContextDao
extends AbstractJdbcBatchMetadataDao {
    private static final String STEP_DISCRIMINATOR = "S";
    private static final String JOB_DISCRIMINATOR = "J";
    private static final String FIND_EXECUTION_CONTEXT = "SELECT TYPE_CD, KEY_NAME, STRING_VAL, DOUBLE_VAL, LONG_VAL, OBJECT_VAL from %PREFIX%EXECUTION_CONTEXT where EXECUTION_ID = ? and DISCRIMINATOR = ?";
    private static final String INSERT_STEP_EXECUTION_CONTEXT = "INSERT into %PREFIX%EXECUTION_CONTEXT(EXECUTION_ID, DISCRIMINATOR, TYPE_CD, KEY_NAME, STRING_VAL, DOUBLE_VAL, LONG_VAL, OBJECT_VAL) values(?,?,?,?,?,?,?,?)";
    private static final String UPDATE_STEP_EXECUTION_CONTEXT = "UPDATE %PREFIX%EXECUTION_CONTEXT set TYPE_CD = ?, STRING_VAL = ?, DOUBLE_VAL = ?, LONG_VAL = ?, OBJECT_VAL = ? where EXECUTION_ID = ? and KEY_NAME = ?";
    private LobHandler lobHandler = new DefaultLobHandler();

    JdbcExecutionContextDao() {
    }

    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        ExecutionContext executionContext = new ExecutionContext();
        this.getJdbcTemplate().query(this.getQuery(FIND_EXECUTION_CONTEXT), new Object[]{executionId, JOB_DISCRIMINATOR}, (RowCallbackHandler)new ExecutionContextRowCallbackHandler(executionContext));
        return executionContext;
    }

    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        ExecutionContext executionContext = new ExecutionContext();
        this.getJdbcTemplate().query(this.getQuery(FIND_EXECUTION_CONTEXT), new Object[]{executionId, STEP_DISCRIMINATOR}, (RowCallbackHandler)new ExecutionContextRowCallbackHandler(executionContext));
        return executionContext;
    }

    public void saveOrUpdateExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        this.saveOrUpdateExecutionContext(executionContext, executionId, JOB_DISCRIMINATOR);
    }

    public void saveOrUpdateExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        this.saveOrUpdateExecutionContext(executionContext, executionId, STEP_DISCRIMINATOR);
    }

    private void saveOrUpdateExecutionContext(ExecutionContext ctx, Long executionId, String discriminator) {
        Iterator it = ctx.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.updateExecutionAttribute(executionId, discriminator, key, value, AttributeType.STRING);
                continue;
            }
            if (value instanceof Double) {
                this.updateExecutionAttribute(executionId, discriminator, key, value, AttributeType.DOUBLE);
                continue;
            }
            if (value instanceof Long) {
                this.updateExecutionAttribute(executionId, discriminator, key, value, AttributeType.LONG);
                continue;
            }
            this.updateExecutionAttribute(executionId, discriminator, key, value, AttributeType.OBJECT);
        }
    }

    private void updateExecutionAttribute(final Long executionId, String discriminator, final String key, final Object value, final AttributeType type) {
        AbstractLobCreatingPreparedStatementCallback callback = new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                ps.setLong(6, executionId);
                ps.setString(7, key);
                if (type == AttributeType.STRING) {
                    ps.setString(1, AttributeType.STRING.toString());
                    ps.setString(2, value.toString());
                    ps.setDouble(3, 0.0);
                    ps.setLong(4, 0L);
                    lobCreator.setBlobAsBytes(ps, 5, null);
                } else if (type == AttributeType.DOUBLE) {
                    ps.setString(1, AttributeType.DOUBLE.toString());
                    ps.setString(2, null);
                    ps.setDouble(3, (Double)value);
                    ps.setLong(4, 0L);
                    lobCreator.setBlobAsBytes(ps, 5, null);
                } else if (type == AttributeType.LONG) {
                    ps.setString(1, AttributeType.LONG.toString());
                    ps.setString(2, null);
                    ps.setDouble(3, 0.0);
                    ps.setLong(4, (Long)value);
                    lobCreator.setBlobAsBytes(ps, 5, null);
                } else {
                    ps.setString(1, AttributeType.OBJECT.toString());
                    ps.setString(2, null);
                    ps.setDouble(3, 0.0);
                    ps.setLong(4, 0L);
                    lobCreator.setBlobAsBytes(ps, 5, SerializationUtils.serialize((Serializable)((Serializable)value)));
                }
            }
        };
        Integer affectedRows = (Integer)this.getJdbcTemplate().execute(this.getQuery(UPDATE_STEP_EXECUTION_CONTEXT), (PreparedStatementCallback)callback);
        if (affectedRows < 1) {
            this.insertExecutionAttribute(executionId, discriminator, key, value, type);
        }
    }

    private void insertExecutionAttribute(final Long executionId, final String discriminator, final String key, final Object value, final AttributeType type) {
        AbstractLobCreatingPreparedStatementCallback callback = new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                ps.setLong(1, executionId);
                ps.setString(2, discriminator);
                ps.setString(4, key);
                if (type == AttributeType.STRING) {
                    ps.setString(3, AttributeType.STRING.toString());
                    ps.setString(5, value.toString());
                    ps.setDouble(6, 0.0);
                    ps.setLong(7, 0L);
                    lobCreator.setBlobAsBytes(ps, 8, null);
                } else if (type == AttributeType.DOUBLE) {
                    ps.setString(3, AttributeType.DOUBLE.toString());
                    ps.setString(5, null);
                    ps.setDouble(6, (Double)value);
                    ps.setLong(7, 0L);
                    lobCreator.setBlobAsBytes(ps, 8, null);
                } else if (type == AttributeType.LONG) {
                    ps.setString(3, AttributeType.LONG.toString());
                    ps.setString(5, null);
                    ps.setDouble(6, 0.0);
                    ps.setLong(7, (Long)value);
                    lobCreator.setBlobAsBytes(ps, 8, null);
                } else {
                    ps.setString(3, AttributeType.OBJECT.toString());
                    ps.setString(5, null);
                    ps.setDouble(6, 0.0);
                    ps.setLong(7, 0L);
                    lobCreator.setBlobAsBytes(ps, 8, SerializationUtils.serialize((Serializable)((Serializable)value)));
                }
            }
        };
        this.getJdbcTemplate().execute(this.getQuery(INSERT_STEP_EXECUTION_CONTEXT), (PreparedStatementCallback)callback);
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    private static class ExecutionContextRowCallbackHandler
    implements RowCallbackHandler {
        private ExecutionContext executionContext;

        public ExecutionContextRowCallbackHandler(ExecutionContext ctx) {
            this.executionContext = ctx;
        }

        public void processRow(ResultSet rs) throws SQLException {
            String typeCd = rs.getString("TYPE_CD");
            AttributeType type = AttributeType.getType(typeCd);
            String key = rs.getString("KEY_NAME");
            if (type == AttributeType.STRING) {
                this.executionContext.putString(key, rs.getString("STRING_VAL"));
            } else if (type == AttributeType.LONG) {
                this.executionContext.putLong(key, rs.getLong("LONG_VAL"));
            } else if (type == AttributeType.DOUBLE) {
                this.executionContext.putDouble(key, rs.getDouble("DOUBLE_VAL"));
            } else if (type == AttributeType.OBJECT) {
                this.executionContext.put(key, SerializationUtils.deserialize((InputStream)rs.getBinaryStream("OBJECT_VAL")));
            } else {
                throw new UnexpectedJobExecutionException("Invalid type found: [" + typeCd + "]");
            }
        }
    }

    private static class AttributeType {
        private final String type;
        public static final AttributeType STRING = new AttributeType("STRING");
        public static final AttributeType LONG = new AttributeType("LONG");
        public static final AttributeType OBJECT = new AttributeType("OBJECT");
        public static final AttributeType DOUBLE = new AttributeType("DOUBLE");
        private static final AttributeType[] VALUES = new AttributeType[]{STRING, OBJECT, LONG, DOUBLE};

        private AttributeType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static AttributeType getType(String typeAsString) {
            for (int i = 0; i < VALUES.length; ++i) {
                if (!VALUES[i].toString().equals(typeAsString)) continue;
                return VALUES[i];
            }
            return null;
        }
    }
}

