/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.ListableJobRegistry;
import org.springframework.batch.core.repository.DuplicateJobException;
import org.springframework.batch.core.repository.NoSuchJobException;
import org.springframework.util.Assert;

public class MapJobRegistry
implements ListableJobRegistry {
    private Map map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(JobFactory jobFactory) throws DuplicateJobException {
        Assert.notNull((Object)jobFactory);
        String name = jobFactory.getJobName();
        Assert.notNull((Object)name, (String)"Job configuration must have a name.");
        Map map = this.map;
        synchronized (map) {
            if (this.map.containsKey(name)) {
                throw new DuplicateJobException("A job configuration with this name [" + name + "] was already registered");
            }
            this.map.put(name, jobFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String name) {
        Assert.notNull((Object)name, (String)"Job configuration must have a name.");
        Map map = this.map;
        synchronized (map) {
            this.map.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getJob(String name) throws NoSuchJobException {
        Map map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(name)) {
                throw new NoSuchJobException("No job configuration with the name [" + name + "] was registered");
            }
            return ((JobFactory)this.map.get(name)).createJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getJobNames() {
        Map map = this.map;
        synchronized (map) {
            return Collections.unmodifiableCollection(new HashSet(this.map.keySet()));
        }
    }
}

