/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.Assert;

public class MapStepExecutionDao
implements StepExecutionDao {
    private static Map executionsByJobExecutionId;
    private static Map contextsByStepExecutionId;
    private static long currentId;

    public static void clear() {
        executionsByJobExecutionId.clear();
        contextsByStepExecutionId.clear();
    }

    public ExecutionContext findExecutionContext(StepExecution stepExecution) {
        return (ExecutionContext)contextsByStepExecutionId.get(stepExecution.getId());
    }

    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isTrue((stepExecution.getId() == null ? 1 : 0) != 0);
        Assert.isTrue((stepExecution.getVersion() == null ? 1 : 0) != 0);
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"JobExecution must be saved already.");
        Map executions = (Map)executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        if (executions == null) {
            executions = TransactionAwareProxyFactory.createTransactionalMap();
            executionsByJobExecutionId.put(stepExecution.getJobExecutionId(), executions);
        }
        stepExecution.setId(new Long(currentId++));
        stepExecution.incrementVersion();
        executions.put(stepExecution.getStepName(), stepExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution.getJobExecutionId());
        Map executions = (Map)executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        Assert.notNull((Object)executions, (String)"step executions for given job execution are expected to be already saved");
        StepExecution persistedExecution = (StepExecution)executions.get(stepExecution.getStepName());
        Assert.notNull((Object)persistedExecution, (String)"step execution is expected to be already saved");
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            if (!persistedExecution.getVersion().equals(stepExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            stepExecution.incrementVersion();
            executions.put(stepExecution.getStepName(), stepExecution);
        }
    }

    public StepExecution getStepExecution(JobExecution jobExecution, Step step) {
        Map executions = (Map)executionsByJobExecutionId.get(jobExecution.getId());
        if (executions == null) {
            return null;
        }
        return (StepExecution)executions.get(step.getName());
    }

    public void saveOrUpdateExecutionContext(StepExecution stepExecution) {
        contextsByStepExecutionId.put(stepExecution.getId(), stepExecution.getExecutionContext());
    }

    static {
        currentId = 0L;
        executionsByJobExecutionId = TransactionAwareProxyFactory.createTransactionalMap();
        contextsByStepExecutionId = TransactionAwareProxyFactory.createTransactionalMap();
    }
}

