/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.skip;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.support.ExceptionClassifier;
import org.springframework.batch.support.SubclassExceptionClassifier;

public class LimitCheckingItemSkipPolicy
implements ItemSkipPolicy {
    private static final String SKIP = "skip";
    private static final String NEVER_SKIP = "neverSkip";
    private final int skipLimit;
    private ExceptionClassifier exceptionClassifier;

    public LimitCheckingItemSkipPolicy(int skipLimit) {
        this(skipLimit, Collections.singletonList(Exception.class), Collections.EMPTY_LIST);
    }

    public LimitCheckingItemSkipPolicy(int skipLimit, List skippableExceptions, List fatalExceptions) {
        Class throwable;
        this.skipLimit = skipLimit;
        SubclassExceptionClassifier exceptionClassifier = new SubclassExceptionClassifier();
        HashMap<Class, String> typeMap = new HashMap<Class, String>();
        Iterator iterator = skippableExceptions.iterator();
        while (iterator.hasNext()) {
            throwable = (Class)iterator.next();
            typeMap.put(throwable, SKIP);
        }
        iterator = fatalExceptions.iterator();
        while (iterator.hasNext()) {
            throwable = (Class)iterator.next();
            typeMap.put(throwable, NEVER_SKIP);
        }
        exceptionClassifier.setTypeMap(typeMap);
        this.exceptionClassifier = exceptionClassifier;
    }

    public boolean shouldSkip(Throwable t, int skipCount) {
        if (this.exceptionClassifier.classify(t).equals(NEVER_SKIP)) {
            return false;
        }
        if (this.exceptionClassifier.classify(t).equals(SKIP)) {
            if (skipCount < this.skipLimit) {
                return true;
            }
            throw new SkipLimitExceededException(this.skipLimit, t);
        }
        return false;
    }
}

